/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.rest;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.ui.web.rest.FancyURLRequestWrapper;
import org.nuxeo.ecm.platform.ui.web.rest.FancyURLResponseWrapper;
import org.nuxeo.ecm.platform.ui.web.rest.api.URLPolicyService;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.runtime.api.Framework;

public class FancyURLFilter
implements Filter {
    private static final Log log = LogFactory.getLog(FancyURLFilter.class);
    protected URLPolicyService urlService;
    protected ServletContext servletContext;

    public void init(FilterConfig conf) throws ServletException {
        log.debug((Object)"Nuxeo5 URLFilter started");
        this.getUrlService(true);
        this.servletContext = conf.getServletContext();
    }

    protected URLPolicyService getUrlService() {
        return this.getUrlService(false);
    }

    protected URLPolicyService getUrlService(boolean silent) {
        block3: {
            if (this.urlService == null) {
                try {
                    this.urlService = (URLPolicyService)Framework.getService(URLPolicyService.class);
                }
                catch (Exception e) {
                    if (silent) break block3;
                    log.error((Object)"Could not retrieve the URLPolicyService", (Throwable)e);
                }
            }
        }
        return this.urlService;
    }

    public void destroy() {
        this.urlService = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        try {
            DocumentView docView;
            this.getUrlService();
            this.urlService.initViewIdManager(this.servletContext);
            if (this.urlService.isCandidateForDecoding(httpRequest) && (docView = this.urlService.getDocumentViewFromRequest(httpRequest)) != null) {
                this.urlService.setDocumentViewInRequest(httpRequest, docView);
                String jsfOutcome = docView.getViewId();
                String target = this.urlService.getViewIdFromOutcome(jsfOutcome, httpRequest);
                RequestDispatcher dispatcher = target != null ? httpRequest.getRequestDispatcher(target) : httpRequest.getRequestDispatcher("/malformed_url_error_page.faces");
                request.setAttribute("nuxeo.force.url.encoding", (Object)Boolean.TRUE);
                dispatcher.forward((ServletRequest)new FancyURLRequestWrapper(httpRequest, docView), this.wrapResponse(httpRequest, httpResponse));
                return;
            }
            chain.doFilter(request, this.wrapResponse(httpRequest, httpResponse));
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
    }

    private ServletResponse wrapResponse(HttpServletRequest request, HttpServletResponse response) {
        return new FancyURLResponseWrapper(response, request);
    }
}

