/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.rest;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.ConfigNavigationCase;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.jboss.seam.util.DTDEntityResolver;
import org.nuxeo.runtime.api.Framework;
import org.xml.sax.EntityResolver;

public class StaticNavigationHandler {
    private static final Log log = LogFactory.getLog(StaticNavigationHandler.class);
    private final HashMap<String, String> outcomeToViewId = new HashMap();
    private final HashMap<String, String> viewIdToOutcome = new HashMap();

    public StaticNavigationHandler(ServletContext context) {
        ApplicationAssociate associate = ApplicationAssociate.getCurrentInstance();
        for (List cases : associate.getNavigationCaseListMappings().values()) {
            for (ConfigNavigationCase cnc : cases) {
                String toViewId = cnc.getToViewId();
                String fromOutcome = cnc.getFromOutcome();
                this.outcomeToViewId.put(fromOutcome, toViewId);
                this.viewIdToOutcome.put(toViewId, fromOutcome);
            }
        }
        if (Framework.isDevModeSet()) {
            this.handleHotReloadResources(context);
        }
    }

    public String getOutcomeFromViewId(String viewId) {
        if (viewId == null) {
            return null;
        }
        if (this.viewIdToOutcome.containsKey(viewId = viewId.replace(".faces", ".xhtml"))) {
            return this.viewIdToOutcome.get(viewId);
        }
        return viewId;
    }

    public String getViewIdFromOutcome(String outcome) {
        if (outcome == null) {
            return null;
        }
        if (this.outcomeToViewId.containsKey(outcome)) {
            return this.outcomeToViewId.get(outcome).replace(".xhtml", ".faces");
        }
        String viewId = "/" + outcome + ".faces";
        log.warn((Object)String.format("Guessing view id for outcome '%s': use '%s'", outcome, viewId));
        return viewId;
    }

    protected void handleHotReloadResources(ServletContext context) {
        InputStream stream = null;
        if (context != null) {
            stream = context.getResourceAsStream("/WEB-INF/faces-config.xml");
        }
        if (stream != null) {
            this.parse(stream);
        }
    }

    protected void parse(InputStream stream) {
        Element root = StaticNavigationHandler.getDocumentRoot(stream);
        List elements = root.elements("navigation-rule");
        for (Element rule : elements) {
            List nav_cases = rule.elements("navigation-case");
            for (Element nav_case : nav_cases) {
                Element from_el = nav_case.element("from-outcome");
                Element to_el = nav_case.element("to-view-id");
                if (from_el == null || to_el == null) continue;
                String from = from_el.getTextTrim();
                String to = to_el.getTextTrim();
                this.outcomeToViewId.put(from, to);
                this.viewIdToOutcome.put(to, from);
            }
        }
    }

    protected static Element getDocumentRoot(InputStream stream) {
        try {
            SAXReader saxReader = new SAXReader();
            saxReader.setEntityResolver((EntityResolver)new DTDEntityResolver());
            saxReader.setMergeAdjacentText(true);
            return saxReader.read(stream).getRootElement();
        }
        catch (DocumentException de) {
            throw new RuntimeException(de);
        }
    }
}

