/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.shield;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import javax.faces.application.Application;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.Seam;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.FacesLifecycle;
import org.jboss.seam.core.ConversationPropagation;
import org.jboss.seam.core.Manager;
import org.jboss.seam.mock.MockApplication;
import org.jboss.seam.mock.MockExternalContext;
import org.jboss.seam.mock.MockFacesContext;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.RegistrationInfo;

public class ErrorPageForwarder {
    private static final Log nuxeoErrorLog = LogFactory.getLog((String)"nuxeo-error-log");
    private static final Log log = LogFactory.getLog(ErrorPageForwarder.class);
    private static final String SEAM_MESSAGES = "org.jboss.seam.international.messages";
    private ServletContext servletContext;

    public void forwardToErrorPage(HttpServletRequest request, HttpServletResponse response, Throwable t, String exceptionMessage, String userMessage, Boolean securityError, ServletContext servletContext) throws ServletException, IOException {
        this.forwardToErrorPage(request, response, this.getStackTraceAsString(t), exceptionMessage, userMessage, securityError, servletContext);
    }

    public void forwardToErrorPage(HttpServletRequest request, HttpServletResponse response, String stackTrace, String exceptionMessage, String userMessage, Boolean securityError, ServletContext servletContext) throws ServletException, IOException {
        log.error((Object)stackTrace);
        this.servletContext = servletContext;
        MockFacesContext facesContext = this.createFacesContext(request, response);
        facesContext.setCurrent();
        Manager manager = Contexts.isEventContextActive() ? (Manager)Contexts.getEventContext().get(Manager.class) : (Manager)request.getAttribute(Seam.getComponentName(Manager.class));
        String conversationId = manager == null ? null : manager.getCurrentConversationId();
        FacesLifecycle.beginExceptionRecovery((ExternalContext)facesContext.getExternalContext());
        if (conversationId == null) {
            Manager.instance().initializeTemporaryConversation();
        } else {
            ConversationPropagation.instance().setConversationId(conversationId);
            Manager.instance().restoreConversation();
        }
        String user_message = request.getAttribute(SEAM_MESSAGES) == null ? "An unexpected error occurred." : (String)((Map)request.getAttribute(SEAM_MESSAGES)).get(userMessage);
        FacesLifecycle.beginExceptionRecovery((ExternalContext)facesContext.getExternalContext());
        request.setAttribute("exception_message", (Object)exceptionMessage);
        request.setAttribute("user_message", (Object)user_message);
        request.setAttribute("stackTrace", (Object)stackTrace);
        request.setAttribute("securityError", (Object)securityError);
        request.setAttribute("request_dump", (Object)this.getRequestDump(request));
        request.getRequestDispatcher("/nuxeo_error.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    private String getRequestDump(HttpServletRequest request) {
        StringBuilder builder = new StringBuilder();
        builder.append("\nParameter:\n");
        Map m = request.getParameterMap();
        for (Map.Entry entry : m.entrySet()) {
            builder.append((String)entry.getKey()).append(":");
            if (entry.getValue() == null) continue;
            for (String s : (String[])entry.getValue()) {
                builder.append(s).append(",");
            }
            builder.deleteCharAt(builder.length() - 1);
            builder.append("\n");
        }
        builder.append("\n");
        Enumeration names = request.getAttributeNames();
        builder.append("Attributes:\n");
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (name.equals(SEAM_MESSAGES)) continue;
            Object obj = request.getAttribute(name);
            builder.append(name).append(": ").append(obj.toString()).append("\n");
        }
        builder.append("\n");
        Collection infos = Framework.getRuntime().getComponentManager().getRegistrations();
        builder.append("Components:\n");
        for (RegistrationInfo info : infos) {
            builder.append(info.getComponent().getName()).append(",").append(info.isActivated() ? "activated" : "not activated").append("\n");
        }
        nuxeoErrorLog.trace((Object)("User Principal: " + request.getUserPrincipal() + "\n" + builder.toString()));
        return builder.toString();
    }

    private MockFacesContext createFacesContext(HttpServletRequest request, HttpServletResponse response) {
        MockFacesContext mockFacesContext = new MockFacesContext((ExternalContext)new MockExternalContext(this.servletContext, request, response), (Application)new MockApplication());
        mockFacesContext.setViewRoot(new UIViewRoot());
        return mockFacesContext;
    }

    public String getStackTraceAsString(Throwable t) {
        StringWriter swriter = new StringWriter();
        PrintWriter pwriter = new PrintWriter(swriter);
        t.printStackTrace(pwriter);
        return swriter.getBuffer().toString();
    }
}

