/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.impl;

import java.io.Serializable;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.CompositeType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.runtime.api.Framework;

public class GraphVariablesUtil {
    private GraphVariablesUtil() {
    }

    protected static SchemaManager getSchemaManager() {
        return (SchemaManager)Framework.getLocalService(SchemaManager.class);
    }

    public static Map<String, Serializable> getVariables(DocumentModel doc, String facetProp) {
        try {
            String facet = (String)((Object)doc.getPropertyValue(facetProp));
            LinkedHashMap<String, Serializable> map = new LinkedHashMap<String, Serializable>();
            if (StringUtils.isBlank((String)facet)) {
                return map;
            }
            CompositeType type = GraphVariablesUtil.getSchemaManager().getFacet(facet);
            if (type == null) {
                return map;
            }
            boolean hasFacet = doc.hasFacet(facet);
            for (Field f : type.getFields()) {
                Serializable value;
                String name = f.getName().getLocalName();
                Serializable serializable = value = hasFacet ? doc.getPropertyValue(name) : null;
                if (value instanceof Calendar) {
                    value = ((Calendar)value).getTime();
                }
                map.put(name, value);
            }
            return map;
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public static void setVariables(DocumentModel doc, String facetProp, Map<String, Serializable> map) {
        try {
            String facet = (String)((Object)doc.getPropertyValue(facetProp));
            if (StringUtils.isBlank((String)facet)) {
                return;
            }
            CompositeType type = GraphVariablesUtil.getSchemaManager().getFacet(facet);
            if (type == null) {
                return;
            }
            boolean hasFacet = doc.hasFacet(facet);
            for (Field f : type.getFields()) {
                String name = f.getName().getLocalName();
                Serializable value = map.get(name);
                if (value == null && !hasFacet) continue;
                if (!hasFacet) {
                    doc.addFacet(facet);
                    hasFacet = true;
                }
                doc.setPropertyValue(name, value);
            }
            CoreSession session = doc.getCoreSession();
            session.saveDocument(doc);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }
}

