/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.asn1.primitives;

import java.io.Serializable;
import org.apache.directory.shared.asn1.codec.DecoderException;

public class BitString
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final BitString EMPTY_STRING = new BitString();
    public static final boolean STREAMED = true;
    private static final int DEFAULT_LENGTH = 8;
    private int nbUnusedBits;
    private boolean isStreamed;
    private byte[] bytes;
    private int nbBytes;
    private int nbBits;

    public BitString() {
        this.bytes = new byte[8];
        this.nbBytes = 0;
        this.isStreamed = false;
        this.nbUnusedBits = 0;
        this.nbBits = 0;
    }

    public BitString(int length) {
        this.nbBits = length;
        this.nbBytes = length / 8 + (length % 8 != 0 ? 1 : 0);
        this.nbUnusedBits = length % 8;
        if (this.nbBytes > 8) {
            this.isStreamed = true;
            this.bytes = new byte[this.nbBytes];
        } else {
            this.isStreamed = false;
            this.bytes = new byte[this.nbBytes];
        }
    }

    public BitString(int length, boolean isStreamed) {
        this.nbBits = length;
        this.isStreamed = isStreamed;
        this.nbBytes = length / 8 + (length % 8 != 0 ? 1 : 0);
        this.nbUnusedBits = length % 8;
        this.bytes = isStreamed ? new byte[this.nbBytes] : new byte[this.nbBytes];
    }

    public BitString(byte[] bytes) {
        this.nbBytes = bytes.length - 1;
        if (this.nbBytes > 8) {
            this.isStreamed = true;
            bytes = new byte[this.nbBytes];
        } else {
            this.isStreamed = false;
            bytes = new byte[this.nbBytes];
        }
        this.setBytes(bytes, this.nbBytes);
    }

    private void setBytes(byte[] bytes, int nbBytes) {
        this.nbUnusedBits = bytes[0] & 7;
        this.nbBits = nbBytes * 8 - this.nbUnusedBits;
        for (int i = 0; i < nbBytes; ++i) {
            this.bytes[i] = bytes[i + 1];
        }
    }

    public void setData(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            this.nbBits = -1;
            return;
        }
        int nbBytes = bytes.length - 1;
        if (nbBytes > 8 && bytes.length < nbBytes) {
            bytes = new byte[nbBytes];
        }
        this.setBytes(bytes, nbBytes);
    }

    public byte[] getData() {
        return this.bytes;
    }

    public byte getUnusedBits() {
        return (byte)this.nbUnusedBits;
    }

    public boolean getBit(int pos) throws DecoderException {
        if (pos > this.nbBits) {
            throw new DecoderException("Cannot get a bit at position " + pos + " when the BitString contains only " + this.nbBits + " ints");
        }
        int posInt = pos / 8;
        int bitNumber = 7 - pos % 8;
        int res = this.bytes[posInt] & 1 << bitNumber;
        return res != 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        try {
            for (int i = 0; i < this.nbBits; ++i) {
                if (this.getBit(i)) {
                    sb.append('1');
                    continue;
                }
                sb.append('0');
            }
        }
        catch (DecoderException de) {
            return "Invalid BitString";
        }
        return sb.toString();
    }

    public boolean isStreamed() {
        return this.isStreamed;
    }
}

