/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webdav.resource;

import java.io.InputStream;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.HEAD;
import javax.ws.rs.PUT;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import net.java.dev.webdav.jaxrs.methods.COPY;
import net.java.dev.webdav.jaxrs.methods.MKCOL;
import net.java.dev.webdav.jaxrs.methods.MOVE;
import net.java.dev.webdav.jaxrs.methods.PROPFIND;
import net.java.dev.webdav.jaxrs.methods.PROPPATCH;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.StreamingBlob;
import org.nuxeo.ecm.webdav.backend.WebDavBackend;
import org.nuxeo.ecm.webdav.resource.AbstractResource;
import org.nuxeo.runtime.services.streaming.InputStreamSource;
import org.nuxeo.runtime.services.streaming.StreamSource;

public class UnknownResource
extends AbstractResource {
    private static final String DS_STORE = ".DS_Store";
    protected WebDavBackend backend;

    public UnknownResource(String path, HttpServletRequest request, WebDavBackend backend) throws Exception {
        super(path, request);
        this.backend = backend;
    }

    @PUT
    public Response put() throws Exception {
        if (DS_STORE.equals(this.name)) {
            throw new WebApplicationException(Response.Status.CONFLICT);
        }
        this.ensureParentExists();
        StreamingBlob content = new StreamingBlob((StreamSource)new InputStreamSource((InputStream)this.request.getInputStream()));
        String contentType = this.request.getContentType();
        if (contentType == null) {
            contentType = "application/octet-stream";
        }
        content.setMimeType(contentType);
        content.setFilename(this.name);
        this.backend.createFile(this.parentPath, this.name, (Blob)content);
        this.backend.saveChanges();
        return Response.created((URI)new URI(this.request.getRequestURI())).build();
    }

    @MKCOL
    public Response mkcol() throws Exception {
        this.ensureParentExists();
        InputStreamSource iss = new InputStreamSource((InputStream)this.request.getInputStream());
        if (iss.getString().length() > 0) {
            return Response.status((int)415).build();
        }
        this.backend.createFolder(this.parentPath, this.name);
        this.backend.saveChanges();
        return Response.created((URI)new URI(this.request.getRequestURI())).build();
    }

    @DELETE
    public Response delete() {
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }

    @COPY
    public Response copy() {
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }

    @MOVE
    public Response move() {
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }

    @PROPFIND
    public Response propfind() {
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }

    @PROPPATCH
    public Response proppatch() {
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }

    @HEAD
    public Response head() {
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }

    private void ensureParentExists() throws Exception {
        if (!this.backend.exists(this.parentPath)) {
            throw new WebApplicationException(Response.Status.CONFLICT);
        }
    }
}

