/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendering.api;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.platform.rendering.api.RenderingEngine;
import org.nuxeo.ecm.platform.rendering.api.RenderingException;

public class View {
    protected RenderingEngine renderingEngine;
    protected String name;
    protected Object object;
    protected Map<String, Object> args;

    public View(RenderingEngine renderingEngine, String name) {
        this(renderingEngine, name, null);
    }

    public View(RenderingEngine renderingEngine, String name, Object object) {
        this.renderingEngine = renderingEngine;
        this.name = name;
        this.args = new HashMap<String, Object>();
        this.forObject(object);
    }

    public String getName() {
        return this.name;
    }

    public Object getObject() {
        return this.object;
    }

    public RenderingEngine getRenderingEngine() {
        return this.renderingEngine;
    }

    public View forObject(Object object) {
        this.object = object;
        this.args.put("This", object);
        return this;
    }

    public View arg(String key, Object value) {
        this.args.put(key, value);
        return this;
    }

    public View args(Map<String, Object> args) {
        this.args.putAll(args);
        return this;
    }

    public void render(OutputStream out) throws RenderingException {
        this.render(new OutputStreamWriter(out));
    }

    public void render(OutputStream out, String charset) throws RenderingException {
        try {
            this.render(new OutputStreamWriter(out, charset));
        }
        catch (RenderingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RenderingException(e);
        }
    }

    public void render(OutputStream out, Charset charset) throws RenderingException {
        this.render(new OutputStreamWriter(out, charset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Writer writer) throws RenderingException {
        try {
            this.renderingEngine.render(this.name, this.args, writer);
        }
        finally {
            try {
                writer.flush();
            }
            catch (Exception e) {
                throw new RenderingException(e);
            }
        }
    }

    public String toString() {
        return this.object != null ? this.object.getClass().getName() + "#" + this.name : this.name;
    }
}

