/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendering.fm.adapters;

import freemarker.template.AdapterTemplateModel;
import freemarker.template.SimpleNumber;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.util.ArrayList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.platform.rendering.fm.adapters.DocumentObjectWrapper;
import org.nuxeo.ecm.platform.rendering.fm.adapters.PropertyWrapper;

public class BlobTemplate
extends PropertyWrapper
implements TemplateHashModelEx,
AdapterTemplateModel {
    protected static final String[] keys = new String[]{"filename", "data", "length", "mimeType", "encoding", "digest"};
    protected final Blob blob;

    public BlobTemplate(DocumentObjectWrapper wrapper, Blob blob) {
        super(wrapper);
        this.blob = blob;
    }

    public Object getAdaptedObject(Class hint) {
        return this.blob;
    }

    public TemplateCollectionModel keys() throws TemplateModelException {
        return (TemplateCollectionModel)this.wrapper.wrap(keys);
    }

    public int size() throws TemplateModelException {
        return keys.length;
    }

    public TemplateCollectionModel values() throws TemplateModelException {
        try {
            ArrayList<Object> list = new ArrayList<Object>(keys.length);
            if (this.blob != null) {
                list.add(this.blob.getFilename());
                list.add(this.blob.getString());
                list.add(this.blob.getLength());
                list.add(this.blob.getMimeType());
                list.add(this.blob.getEncoding());
                list.add(this.blob.getDigest());
            } else {
                list.add("");
                list.add("");
                list.add("");
                list.add("");
                list.add("");
                list.add("");
            }
            return (TemplateCollectionModel)this.wrapper.wrap(list);
        }
        catch (Exception e) {
            throw new TemplateModelException("Failed to adapt complex property values", e);
        }
    }

    public TemplateModel get(String name) throws TemplateModelException {
        try {
            if (this.blob != null) {
                if (keys[0].equals(name)) {
                    return new SimpleScalar(this.blob.getFilename());
                }
                if (keys[1].equals(name)) {
                    return new SimpleScalar(this.blob.getString());
                }
                if (keys[2].equals(name)) {
                    return new SimpleNumber(this.blob.getLength());
                }
                if (keys[3].equals(name)) {
                    return new SimpleScalar(this.blob.getMimeType());
                }
                if (keys[4].equals(name)) {
                    return new SimpleScalar(this.blob.getEncoding());
                }
                if (keys[5].equals(name)) {
                    return new SimpleScalar(this.blob.getDigest());
                }
            }
            return NOTHING;
        }
        catch (IOException e) {
            throw new TemplateModelException((Exception)e);
        }
    }

    public boolean isEmpty() throws TemplateModelException {
        return false;
    }
}

