/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.api.operation;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;

@Operation(id="Context.StartWorkflow", category="Workflow Context", label="Start workflow", requires="Workflow", description="Starts the workflow with the given model id on the input documents. Returns back the input documents. The created workflow instance id is available under the \"WorkflowId\" context variable")
public class StartWorkflowOperation {
    public static final String ID = "Context.StartWorkflow";
    @Context
    protected CoreSession session;
    @Context
    protected OperationContext ctx;
    @Param(name="id", required=true)
    protected String id;
    @Param(name="start", required=false)
    protected Boolean start;
    @Context
    protected DocumentRoutingService documentRoutingService;

    @OperationMethod
    public DocumentModelList run(DocumentModelList docs) throws ClientException {
        ArrayList<String> ids = new ArrayList<String>();
        for (DocumentModel doc : docs) {
            ids.add(doc.getId());
        }
        this.startNewInstance(ids);
        return docs;
    }

    @OperationMethod
    public DocumentModel run(DocumentModel doc) throws ClientException {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(doc.getId());
        this.startNewInstance(ids);
        return doc;
    }

    protected void startNewInstance(List<String> ids) throws ClientException {
        String workflowId = this.documentRoutingService.createNewInstance(this.id, ids, this.session, Boolean.TRUE.equals(this.start));
        this.ctx.put("WorkflowId", (Object)workflowId);
    }
}

