/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.relations.web.listener.ejb;

import java.util.Locale;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import org.nuxeo.common.utils.i18n.I18NUtils;

public class RelationCreationBean {
    protected UIInput objectTypeInput;
    protected UIInput objectLiteralValueInput;
    protected UIInput objectUriInput;
    protected UIInput objectDocumentTitleInput;
    protected UIInput objectDocumentUidInput;

    public UIInput getObjectLiteralValueInput() {
        return this.objectLiteralValueInput;
    }

    public void setObjectLiteralValueInput(UIInput objectLiteralValueInput) {
        this.objectLiteralValueInput = objectLiteralValueInput;
    }

    public UIInput getObjectTypeInput() {
        return this.objectTypeInput;
    }

    public void setObjectTypeInput(UIInput objectTypeInput) {
        this.objectTypeInput = objectTypeInput;
    }

    public UIInput getObjectUriInput() {
        return this.objectUriInput;
    }

    public void setObjectUriInput(UIInput objectUriInput) {
        this.objectUriInput = objectUriInput;
    }

    public UIInput getObjectDocumentTitleInput() {
        return this.objectDocumentTitleInput;
    }

    public void setObjectDocumentTitleInput(UIInput objectDocumentTitleInput) {
        this.objectDocumentTitleInput = objectDocumentTitleInput;
    }

    public UIInput getObjectDocumentUidInput() {
        return this.objectDocumentUidInput;
    }

    public void setObjectDocumentUidInput(UIInput objectDocumentUidInput) {
        this.objectDocumentUidInput = objectDocumentUidInput;
    }

    public void validateObject(FacesContext context, UIComponent component, Object value) {
        FacesMessage message;
        String objectType = (String)this.objectTypeInput.getLocalValue();
        String objectValue = null;
        String bundleName = context.getApplication().getMessageBundle();
        Locale locale = context.getViewRoot().getLocale();
        if (objectType == null) {
            String msg = I18NUtils.getMessageString((String)bundleName, (String)"error.relation.required.object.type", null, (Locale)locale);
            message = new FacesMessage(msg);
        } else if (objectType.equals("literal")) {
            objectValue = ((String)this.objectLiteralValueInput.getLocalValue()).trim();
            String msg = I18NUtils.getMessageString((String)bundleName, (String)"error.relation.required.object.text", null, (Locale)locale);
            message = new FacesMessage(msg);
        } else if (objectType.equals("uri")) {
            objectValue = ((String)this.objectUriInput.getLocalValue()).trim();
            String msg = I18NUtils.getMessageString((String)bundleName, (String)"error.relation.required.object.uri", null, (Locale)locale);
            message = new FacesMessage(msg);
        } else if (objectType.equals("document")) {
            if (null != this.objectDocumentUidInput) {
                objectValue = ((String)this.objectDocumentUidInput.getLocalValue()).trim();
            }
            String msg = I18NUtils.getMessageString((String)bundleName, (String)"error.relation.required.object.document", null, (Locale)locale);
            message = new FacesMessage(msg);
        } else {
            String msg = I18NUtils.getMessageString((String)bundleName, (String)"error.relation.invalid.object.type", null, (Locale)locale);
            message = new FacesMessage(msg);
        }
        if (objectValue == null || objectValue.length() == 0) {
            message.setSeverity(FacesMessage.SEVERITY_ERROR);
            throw new ValidatorException(message);
        }
    }
}

