/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.DocumentTypeDescriptor;
import org.nuxeo.ecm.core.schema.DocumentTypeImpl;
import org.nuxeo.ecm.core.schema.FacetDescriptor;
import org.nuxeo.ecm.core.schema.Namespace;
import org.nuxeo.ecm.core.schema.PrefetchInfo;
import org.nuxeo.ecm.core.schema.SchemaDescriptor;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.TypeProvider;
import org.nuxeo.ecm.core.schema.TypeRef;
import org.nuxeo.ecm.core.schema.XSDTypes;
import org.nuxeo.ecm.core.schema.registries.DocumentTypeRegistry;
import org.nuxeo.ecm.core.schema.registries.FacetRegistry;
import org.nuxeo.ecm.core.schema.registries.SchemaRegistry;
import org.nuxeo.ecm.core.schema.registries.SchemaTypeRegistry;
import org.nuxeo.ecm.core.schema.types.AnyType;
import org.nuxeo.ecm.core.schema.types.CompositeType;
import org.nuxeo.ecm.core.schema.types.CompositeTypeImpl;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.QName;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.SimpleType;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class SchemaManagerImpl
implements SchemaManager {
    private static final Log log = LogFactory.getLog(SchemaManagerImpl.class);
    private final SchemaTypeRegistry typeReg;
    private final DocumentTypeRegistry docTypeReg;
    private final FacetRegistry facetReg;
    private final SchemaRegistry schemaReg;
    private final Map<String, List<DocumentTypeDescriptor>> pendingDocTypes;
    private final Map<String, Field> fields = new HashMap<String, Field>();
    private File schemaDir;
    private PrefetchInfo prefetchInfo;

    public SchemaManagerImpl() throws Exception {
        this.pendingDocTypes = new HashMap<String, List<DocumentTypeDescriptor>>();
        this.schemaDir = new File(Framework.getRuntime().getHome(), "schemas");
        this.typeReg = new SchemaTypeRegistry();
        this.docTypeReg = new DocumentTypeRegistry();
        this.facetReg = new FacetRegistry();
        this.schemaReg = new SchemaRegistry();
        if (!this.schemaDir.isDirectory()) {
            this.schemaDir.mkdirs();
        }
        for (SimpleType type : XSDTypes.getTypes()) {
            this.registerType(type);
        }
        this.registerBuiltinTypes();
        TypeProvider provider = (TypeProvider)Framework.getService(TypeProvider.class);
        if (provider != this && provider != null) {
            this.importTypes(provider);
        }
    }

    protected void registerBuiltinTypes() {
        this.registerDocumentType(new DocumentTypeImpl(null, "Document", null, null, 256));
        this.registerType(AnyType.INSTANCE);
    }

    public synchronized void importTypes(TypeProvider provider) {
        Type[] types;
        Schema[] schemas;
        DocumentType[] docTypes;
        for (DocumentType docType : docTypes = provider.getDocumentTypes()) {
            this.registerDocumentType(docType);
        }
        for (Schema schema : schemas = provider.getSchemas()) {
            this.registerSchema(schema);
        }
        for (Type type : types = provider.getTypes()) {
            this.registerType(type);
        }
        for (Type type : provider.getFacets()) {
            this.registerFacet((CompositeType)type);
        }
    }

    @Override
    public Type getType(String schema, String name) {
        if ("@builtin".equals(schema)) {
            return this.typeReg.getType(name);
        }
        if ("@doctypes".equals(schema)) {
            return this.docTypeReg.getType(name);
        }
        if ("@schemas".equals(schema)) {
            return this.schemaReg.getSchema(name);
        }
        if ("@facets".equals(schema)) {
            return this.facetReg.getFacet(name);
        }
        Schema ownerSchema = this.schemaReg.getSchema(schema);
        if (ownerSchema != null) {
            return ownerSchema.getType(name);
        }
        return null;
    }

    @Override
    public void registerType(Type type) {
        String schema = type.getSchemaName();
        if ("@builtin".equals(schema)) {
            this.typeReg.addContribution(type);
        } else if ("@schemas".equals(schema)) {
            this.schemaReg.addContribution((Schema)type);
        } else if ("@doctypes".equals(schema)) {
            this.docTypeReg.addContribution((DocumentType)type);
        } else if ("@facets".equals(schema)) {
            this.facetReg.addContribution((CompositeType)type);
        } else {
            Schema ownerSchema = this.schemaReg.getSchema(schema);
            if (ownerSchema != null) {
                ownerSchema.registerType(type);
            }
        }
    }

    @Override
    public Type unregisterType(String name) {
        Type type = this.getType(name);
        this.typeReg.removeContribution(type);
        return type;
    }

    @Override
    public Type getType(String name) {
        return this.typeReg.getType(name);
    }

    @Override
    public Type[] getTypes() {
        return this.typeReg.getTypes();
    }

    @Override
    public Type[] getTypes(String schema) {
        Schema ownerSchema = this.schemaReg.getSchema(schema);
        if (schema != null) {
            return ownerSchema.getTypes();
        }
        return null;
    }

    @Override
    public int getTypesCount() {
        return this.typeReg.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerSchema(Schema schema) {
        SchemaRegistry schemaRegistry = this.schemaReg;
        synchronized (schemaRegistry) {
            this.schemaReg.addContribution(schema);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Schema unregisterSchema(String name) {
        Schema schema = this.schemaReg.getSchema(name);
        if (schema == null) {
            return null;
        }
        Namespace ns = schema.getNamespace();
        log.info((Object)("Unregister schema: " + name));
        SchemaRegistry schemaRegistry = this.schemaReg;
        synchronized (schemaRegistry) {
            this.schemaReg.removeContribution(schema);
            return schema;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Schema getSchema(String name) {
        SchemaRegistry schemaRegistry = this.schemaReg;
        synchronized (schemaRegistry) {
            return this.schemaReg.getSchema(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Schema getSchemaFromPrefix(String schemaPrefix) {
        SchemaRegistry schemaRegistry = this.schemaReg;
        synchronized (schemaRegistry) {
            return this.schemaReg.getSchemaFromPrefix(schemaPrefix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Schema getSchemaFromURI(String schemaURI) {
        SchemaRegistry schemaRegistry = this.schemaReg;
        synchronized (schemaRegistry) {
            return this.schemaReg.getSchemaFromURI(schemaURI);
        }
    }

    @Override
    public Field getField(String prefixedName) {
        Field field = this.fields.get(prefixedName);
        if (field == null) {
            QName qname = QName.valueOf(prefixedName);
            String prefix = qname.getPrefix();
            Schema schema = this.getSchemaFromPrefix(prefix);
            if (schema == null) {
                schema = this.getSchema(prefix);
            }
            if (schema != null && (field = schema.getField(qname.getLocalName())) != null) {
                this.fields.put(prefixedName, field);
            }
        }
        return field;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Schema[] getSchemas() {
        SchemaRegistry schemaRegistry = this.schemaReg;
        synchronized (schemaRegistry) {
            return this.schemaReg.getSchemas();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSchemasCount() {
        SchemaRegistry schemaRegistry = this.schemaReg;
        synchronized (schemaRegistry) {
            return this.schemaReg.size();
        }
    }

    public void setPrefetchInfo(PrefetchInfo prefetchInfo) {
        this.prefetchInfo = prefetchInfo;
    }

    public PrefetchInfo getPrefetchInfo() {
        return this.prefetchInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerDocumentType(DocumentType docType) {
        log.info((Object)("Register document type: " + docType.getName()));
        DocumentTypeRegistry documentTypeRegistry = this.docTypeReg;
        synchronized (documentTypeRegistry) {
            this.docTypeReg.addContribution(docType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDocumentType(DocumentTypeDescriptor dtd) {
        DocumentTypeRegistry documentTypeRegistry = this.docTypeReg;
        synchronized (documentTypeRegistry) {
            DocumentType superType = null;
            if (dtd.superTypeName != null && (superType = this.docTypeReg.getType(dtd.superTypeName)) == null) {
                this.postponeDocTypeRegistration(dtd);
                return;
            }
            this.registerDocumentType(superType, dtd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DocumentType registerDocumentType(DocumentType superType, DocumentTypeDescriptor dtd) {
        DocumentTypeRegistry documentTypeRegistry = this.docTypeReg;
        synchronized (documentTypeRegistry) {
            try {
                Set<String> schemaNames = SchemaDescriptor.getSchemaNames(dtd.schemas);
                for (String facetName : dtd.facets) {
                    CompositeType facet = this.getFacet(facetName);
                    if (facet != null) {
                        schemaNames.addAll(Arrays.asList(facet.getSchemaNames()));
                        continue;
                    }
                    log.warn((Object)("Document type " + dtd.name + " uses undeclared facet: " + facetName));
                    CompositeTypeImpl ct = new CompositeTypeImpl((TypeRef<? extends CompositeType>)null, "@facets", facetName, null);
                    this.registerFacet(ct);
                }
                DocumentTypeImpl docType = new DocumentTypeImpl(superType, dtd.name, schemaNames.toArray(new String[0]), dtd.facets);
                docType.setChildrenTypes(dtd.childrenTypes);
                docType.setPrefetchInfo(dtd.prefetch != null ? new PrefetchInfo(dtd.prefetch) : this.prefetchInfo);
                this.docTypeReg.addContribution(docType);
                log.info((Object)("Registered document type: " + dtd.name));
                this.registerPendingDocTypes(docType);
                return docType;
            }
            catch (Exception e) {
                log.error((Object)("Error registering document type: " + dtd.name), (Throwable)e);
                return null;
            }
        }
    }

    private void registerPendingDocTypes(DocumentType superType) {
        List<DocumentTypeDescriptor> list = this.pendingDocTypes.remove(superType.getName());
        if (list == null) {
            return;
        }
        for (DocumentTypeDescriptor dtd : list) {
            this.registerDocumentType(superType, dtd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocumentType unregisterDocumentType(String name) {
        log.info((Object)("Unregister document type: " + name));
        DocumentTypeRegistry documentTypeRegistry = this.docTypeReg;
        synchronized (documentTypeRegistry) {
            DocumentType docType = this.docTypeReg.getType(name);
            if (docType != null) {
                this.docTypeReg.removeContribution(docType);
            }
            return docType;
        }
    }

    private void postponeDocTypeRegistration(DocumentTypeDescriptor dtd) {
        List<DocumentTypeDescriptor> list = this.pendingDocTypes.get(dtd.superTypeName);
        if (list == null) {
            list = new ArrayList<DocumentTypeDescriptor>();
            this.pendingDocTypes.put(dtd.superTypeName, list);
        }
        list.add(dtd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocumentType getDocumentType(String name) {
        DocumentTypeRegistry documentTypeRegistry = this.docTypeReg;
        synchronized (documentTypeRegistry) {
            return this.docTypeReg.getType(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocumentType[] getDocumentTypes() {
        DocumentTypeRegistry documentTypeRegistry = this.docTypeReg;
        synchronized (documentTypeRegistry) {
            return this.docTypeReg.getDocumentTypes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDocumentTypesCount() {
        DocumentTypeRegistry documentTypeRegistry = this.docTypeReg;
        synchronized (documentTypeRegistry) {
            return this.docTypeReg.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerFacet(CompositeType facet) {
        FacetRegistry facetRegistry = this.facetReg;
        synchronized (facetRegistry) {
            this.facetReg.addContribution(facet);
            log.info((Object)("Registered facet: " + facet.getName()));
        }
    }

    public void registerFacet(FacetDescriptor fd) {
        Set<String> schemas = SchemaDescriptor.getSchemaNames(fd.schemas);
        CompositeTypeImpl ct = new CompositeTypeImpl((TypeRef<? extends CompositeType>)null, "@facets", fd.name, schemas.toArray(new String[0]));
        this.registerFacet(ct);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompositeType unregisterFacet(String name) {
        FacetRegistry facetRegistry = this.facetReg;
        synchronized (facetRegistry) {
            log.info((Object)("Unregistered facet: " + name));
            CompositeType facet = this.facetReg.getFacet(name);
            this.facetReg.removeContribution(facet);
            return facet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompositeType getFacet(String name) {
        FacetRegistry facetRegistry = this.facetReg;
        synchronized (facetRegistry) {
            return this.facetReg.getFacet(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompositeType[] getFacets() {
        FacetRegistry facetRegistry = this.facetReg;
        synchronized (facetRegistry) {
            return this.facetReg.getFacets();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        ContributionFragmentRegistry contributionFragmentRegistry = this.docTypeReg;
        synchronized (contributionFragmentRegistry) {
            this.docTypeReg.clear();
        }
        contributionFragmentRegistry = this.schemaReg;
        synchronized (contributionFragmentRegistry) {
            this.schemaReg.clear();
        }
        this.typeReg.clear();
        this.facetReg.clear();
    }

    public void setSchemaDirectory(File dir) {
        this.schemaDir = dir;
    }

    public File getSchemaDirectory() {
        return this.schemaDir;
    }

    public File getSchemaFile(String name) {
        return new File(this.schemaDir, name + ".xsd");
    }

    public URL resolveSchemaLocation(String location) {
        if (location.startsWith("schema://")) {
            try {
                return new File(this.schemaDir, location).toURI().toURL();
            }
            catch (MalformedURLException e) {
                log.error((Object)("failed to resolve schema location: " + location), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public Set<String> getDocumentTypeNamesForFacet(String facet) {
        return this.docTypeReg.getDocumentTypeNamesForFacet(facet);
    }

    @Override
    public Set<String> getDocumentTypeNamesExtending(String docTypeName) {
        return this.docTypeReg.getDocumentTypeNamesExtending(docTypeName);
    }

    @Override
    public String getXmlSchemaDefinition(String name) {
        File file = this.getSchemaFile(name);
        if (file != null) {
            try {
                return FileUtils.readFile((File)file);
            }
            catch (IOException e) {
                log.error((Object)String.format("Could not read xsd file for '%s'", name), (Throwable)e);
                return null;
            }
        }
        return null;
    }
}

