/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.forms.validation;

import org.nuxeo.ecm.webengine.forms.validation.FieldValidator;
import org.nuxeo.ecm.webengine.forms.validation.ValidationException;

public class RangeValidator
implements FieldValidator {
    protected boolean negate;
    protected double min = Double.MIN_VALUE;
    protected double max = Double.MAX_VALUE;

    public RangeValidator(double min, double max, boolean negate) {
        this.min = min;
        this.max = max;
        this.negate = negate;
    }

    public boolean validateNumber(Number value) {
        boolean result;
        double d = value.doubleValue();
        boolean bl = result = d > this.min && d < this.max;
        return this.negate ? !result : result;
    }

    @Override
    public void validate(String value, Object decoded) throws ValidationException {
        if (!this.validateNumber((Number)decoded)) {
            throw new ValidationException();
        }
    }
}

