/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.loader;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.loader.ClassProxy;
import org.nuxeo.ecm.webengine.loader.GroovyClassProxy;
import org.nuxeo.ecm.webengine.loader.ReloadingClassLoader;
import org.nuxeo.ecm.webengine.loader.StaticClassProxy;
import org.nuxeo.ecm.webengine.loader.store.FileResourceStore;
import org.nuxeo.ecm.webengine.scripting.GroovyScripting;
import org.osgi.framework.Bundle;

public class WebLoader {
    private static final Log log = LogFactory.getLog(WebLoader.class);
    protected final WebEngine engine;
    protected final ReloadingClassLoader classLoader;
    protected final GroovyScripting gScripting;

    public WebLoader(WebEngine engine) {
        this.engine = engine;
        File root = engine.getRootDirectory();
        this.classLoader = new ReloadingClassLoader(WebLoader.getParentLoader());
        this.gScripting = new GroovyScripting((ClassLoader)this.classLoader, engine.isDevMode());
        this.addClassPathElement(new File(root, "WEB-INF/classes"));
    }

    public WebEngine getEngine() {
        return this.engine;
    }

    public void addClassPathElement(File container) {
        try {
            this.classLoader.addResourceStore(new FileResourceStore(container));
            this.gScripting.getGroovyClassLoader().addURL(container.toURI().toURL());
        }
        catch (MalformedURLException e) {
            log.error((Object)("Failed to convert file to url: " + container), (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)("Failed to create file store: " + container), (Throwable)e);
        }
    }

    public URL getResource(String name) {
        return this.classLoader.getResource(name);
    }

    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.classLoader.loadClass(name);
    }

    public ReloadingClassLoader getClassLoader() {
        return this.classLoader;
    }

    public GroovyScripting getGroovyScripting() {
        return this.gScripting;
    }

    public void flushCache() {
        log.info((Object)"Flushing loader cache");
        this.classLoader.reload();
        this.gScripting.clearCache();
    }

    public ClassProxy getGroovyClassProxy(String className) throws ClassNotFoundException {
        return this.engine.isDevMode() ? new GroovyClassProxy(this.gScripting.getGroovyClassLoader(), className) : new StaticClassProxy(this.gScripting.loadClass(className));
    }

    public ClassProxy getClassProxy(String className) throws ClassNotFoundException {
        return new StaticClassProxy(this.classLoader.loadClass(className));
    }

    public ClassProxy getClassProxy(Bundle bundle, String className) throws ClassNotFoundException {
        return new StaticClassProxy(bundle.loadClass(className));
    }

    public static ClassLoader getParentLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return cl == null ? GroovyScripting.class.getClassLoader() : cl;
    }
}

