/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.model;

import javax.ws.rs.core.MediaType;
import org.nuxeo.ecm.webengine.model.Resource;
import org.nuxeo.ecm.webengine.model.Template;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.ecm.webengine.scripting.ScriptFile;

public class View
extends Template {
    protected String name;
    protected String ext;
    protected MediaType mediaType;

    protected View(WebContext ctx, Resource resource, String name) {
        super(ctx, resource, null);
        this.mediaType = ctx.getHttpHeaders().getMediaType();
        this.name = name;
    }

    public View(WebContext ctx, String name) {
        this(ctx, null, name);
    }

    public View(Resource resource, String name) {
        this(resource.getContext(), resource, name);
    }

    public View mediaType(MediaType mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    public View name(String name) {
        this.name = name;
        return this;
    }

    public View extension(String ext) {
        this.ext = ext;
        return this;
    }

    public MediaType mediaType() {
        return this.mediaType;
    }

    public View fileName(String fileName) {
        this.resolve(fileName);
        return this;
    }

    public View script(ScriptFile script) {
        this.script = script;
        return this;
    }

    @Override
    public ScriptFile script() {
        if (this.script == null) {
            String mediaId;
            StringBuilder fileName = new StringBuilder();
            fileName.append(this.name);
            if (this.mediaType != null && (mediaId = this.ctx.getModule().getMediaTypeId(this.mediaType)) != null) {
                fileName.append('-').append(mediaId);
            }
            if (this.ext == null) {
                this.ext = this.ctx.getModule().getTemplateFileExt();
            }
            fileName.append('.').append(this.ext);
            this.resolve(fileName.toString());
        }
        return this.script;
    }

    public View resolve() {
        this.script();
        return this;
    }
}

