/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.model.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.webengine.ResourceBinding;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.LinkDescriptor;
import org.nuxeo.ecm.webengine.model.Module;
import org.nuxeo.ecm.webengine.model.Validator;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.model.impl.MediaTypeRef;
import org.nuxeo.ecm.webengine.model.impl.ModuleImpl;
import org.nuxeo.ecm.webengine.model.impl.ModuleShortcut;

@XObject(value="module")
public class ModuleConfiguration
implements Cloneable {
    private static final Log log = LogFactory.getLog(ModuleConfiguration.class);
    @Deprecated
    @XNode(value="@path")
    public String path;
    @Deprecated
    @XNode(value="@root-type")
    public String rootType;
    public Class<?>[] roots;
    @XNode(value="@extends")
    public String base;
    @XNode(value="@name")
    public String name;
    @Deprecated
    @XNode(value="@headless")
    public boolean isHeadless;
    @XNodeList(value="shortcuts/shortcut", type=ArrayList.class, componentType=ModuleShortcut.class, nullByDefault=true)
    public List<ModuleShortcut> moduleShortcuts;
    public Class<?>[] types;
    @XNode(value="home")
    public File directory;
    @XNodeList(value="fragments/directory", type=ArrayList.class, componentType=File.class, nullByDefault=false)
    public List<File> fragmentDirectories = new ArrayList<File>();
    public File file;
    @XNodeList(value="nature", type=HashSet.class, componentType=String.class, nullByDefault=true)
    public Set<String> natures;
    @XNodeList(value="links/link", type=ArrayList.class, componentType=LinkDescriptor.class, nullByDefault=true)
    public List<LinkDescriptor> links;
    public Map<String, Validator> validators;
    @XNodeList(value="resources/resource", type=ArrayList.class, componentType=ResourceBinding.class, nullByDefault=true)
    public List<ResourceBinding> resources;
    @XNode(value="templateFileExt")
    public String templateFileExt = "ftl";
    @XNodeList(value="media-types/media-type", type=MediaTypeRef[].class, componentType=MediaTypeRef.class, nullByDefault=true)
    public MediaTypeRef[] mediatTypeRefs;
    public WebEngine engine;
    private ModuleImpl module;

    @XNodeMap(value="validators/validator", key="@type", type=HashedMap.class, componentType=Class.class, nullByDefault=true)
    public void setValidators(Map<String, Class<Validator>> m) {
        if (m != null) {
            this.validators = new HashMap<String, Validator>();
            for (Map.Entry<String, Class<Validator>> entry : m.entrySet()) {
                try {
                    this.validators.put(entry.getKey(), entry.getValue().newInstance());
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
            }
        }
    }

    public ModuleConfiguration() {
    }

    public ModuleConfiguration(WebEngine engine) {
        this.engine = engine;
    }

    public WebEngine getEngine() {
        return this.engine;
    }

    public void setEngine(WebEngine engine) {
        this.engine = engine;
    }

    public String getName() {
        return this.name;
    }

    public List<ModuleShortcut> getShortcuts() {
        return this.moduleShortcuts;
    }

    public List<LinkDescriptor> getLinks() {
        return this.links;
    }

    public File getDirectory() {
        return this.directory;
    }

    public String getBase() {
        return this.base;
    }

    @Deprecated
    public String getPath() {
        return this.path;
    }

    public Module get() {
        if (this.module == null) {
            try {
                Module superModule = null;
                if (this.base != null) {
                    ModuleConfiguration superM = this.engine.getModuleManager().getModule(this.base);
                    if (superM == null) {
                        throw new WebResourceNotFoundException("The module '" + this.name + "' cannot be loaded since it's super module '" + this.base + "' cannot be found");
                    }
                    superModule = superM.get();
                }
                this.module = new ModuleImpl(this.engine, (ModuleImpl)superModule, this);
            }
            catch (Exception e) {
                throw WebException.wrap(e);
            }
        }
        return this.module;
    }

    public boolean isLoaded() {
        return this.module != null;
    }

    public boolean isHeadless() {
        return this.isHeadless;
    }
}

