/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.security;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

public class PostfixExpression
implements Iterable<Token> {
    public static final int ARG = 0;
    public static final int NOT = 1;
    public static final int AND = 2;
    public static final int OR = 3;
    public static final int PARA = 4;
    public static final int LPARA = 5;
    public static final int RPARA = 6;
    protected Token[] expr;

    public PostfixExpression(String expr) throws ParseException {
        this.parse(expr);
    }

    public Token[] getExpression() {
        return this.expr;
    }

    @Override
    public Iterator<Token> iterator() {
        return Arrays.asList(this.expr).iterator();
    }

    private static void pushOp(Token tok, OpStack stack, List<Token> result) {
        if (!stack.isEmpty() && stack.top().type <= tok.type) {
            result.add(stack.pop());
        }
        stack.push(tok);
    }

    public Object visit(Visitor visitor) {
        LinkedList<Object> stack = new LinkedList<Object>();
        for (Token token : this.expr) {
            Object lparam;
            int arity;
            if (token.type == 0) {
                stack.add(visitor.createParameter(token));
                continue;
            }
            Object rparam = null;
            int n = arity = token.type > 1 ? 2 : 1;
            if (arity == 1) {
                lparam = stack.removeLast();
            } else {
                rparam = stack.removeLast();
                lparam = stack.removeLast();
            }
            stack.add(visitor.createOperation(token, lparam, rparam));
        }
        return stack.getLast();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Token token : this.expr) {
            sb.append(token.name).append(" ");
        }
        return sb.toString();
    }

    protected void parse(String expr) throws ParseException {
        OpStack stack = new OpStack();
        ArrayList<Token> result = new ArrayList<Token>();
        StringTokenizer tok = new StringTokenizer(expr, " \t\n\r\f()", true);
        block5: while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            char c = token.charAt(0);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    continue block5;
                }
                case '(': {
                    stack.push(new Token(5, "("));
                    continue block5;
                }
                case ')': {
                    while (!stack.isEmpty() && stack.top().type != 5) {
                        result.add(stack.pop());
                    }
                    if (stack.isEmpty()) {
                        throw new ParseException("Not matching LPARA '(' found ", -1);
                    }
                    stack.pop();
                    continue block5;
                }
            }
            if ("OR".equals(token)) {
                PostfixExpression.pushOp(new Token(3, "OR"), stack, result);
                continue;
            }
            if ("AND".equals(token)) {
                PostfixExpression.pushOp(new Token(2, "AND"), stack, result);
                continue;
            }
            if ("NOT".equals(token)) {
                PostfixExpression.pushOp(new Token(1, "NOT"), stack, result);
                continue;
            }
            result.add(new Token(0, token));
        }
        while (!stack.isEmpty()) {
            result.add(stack.pop());
        }
        this.expr = result.toArray(new Token[result.size()]);
    }

    public static class OpStack
    extends LinkedList<Token> {
        private static final long serialVersionUID = 1L;

        @Override
        public final void push(Token token) {
            this.add(token);
        }

        @Override
        public final Token pop() {
            return (Token)this.removeLast();
        }

        public final Token top() {
            return (Token)this.getLast();
        }
    }

    public static class Token {
        public final int type;
        public final String name;

        public Token(int type, String name) {
            this.type = type;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static interface Visitor {
        public Object createParameter(Token var1);

        public Object createOperation(Token var1, Object var2, Object var3);
    }
}

