/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.mimetype.detectors;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import net.sf.jmimemagic.MagicDetector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;

public class MsoXmlMimetypeSniffer
implements MagicDetector {
    private static final Log log = LogFactory.getLog(MsoXmlMimetypeSniffer.class);

    public String getDisplayName() {
        return "XML Microsoft 2003 MimeType Detector";
    }

    public String[] getHandledExtensions() {
        return new String[]{"xml"};
    }

    public String[] getHandledTypes() {
        return new String[]{"application/vnd.ms-excel", "application/msword"};
    }

    public String getName() {
        return "msoxml2003detector";
    }

    public String getVersion() {
        return "0.1";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] process(byte[] data, int offset, int length, long bitmask, char comparator, String mimeType, Map params) {
        String[] mimetypes = new String[]{};
        File file = null;
        try {
            file = File.createTempFile("magicdetector", ".xml");
            FileUtils.writeFile((File)file, (byte[])data);
            mimetypes = this.guessMsoXml(file);
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
        return mimetypes;
    }

    public String[] process(File file, int offset, int length, long bitmask, char comparator, String mimeType, Map params) {
        return this.guessMsoXml(file);
    }

    public String[] guessMsoXml(File file) {
        String[] mimetype = new String[]{};
        try {
            String content = FileUtils.readFile((File)file);
            if (content.contains("<?mso-application progid=\"Word.Document\"?>")) {
                String[] type = new String[]{this.getHandledTypes()[1]};
                mimetype = type;
            } else if (content.contains("<?mso-application progid=\"Excel.Sheet\"?>")) {
                String[] type = new String[]{this.getHandledTypes()[0]};
                mimetype = type;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return mimetype;
    }
}

