/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.common.xmap.annotation.XContent;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationParameters;
import org.nuxeo.ecm.automation.core.impl.adapters.StringToDocRef;
import org.nuxeo.ecm.automation.core.scripting.Scripting;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.core.api.impl.DocumentRefListImpl;
import org.nuxeo.ecm.core.schema.utils.DateParser;
import org.osgi.framework.Bundle;

@XObject(value="chain")
public class OperationChainContribution {
    @XNode(value="@id")
    protected String id;
    @XNode(value="@replace")
    protected boolean replace;
    @XNode(value="description")
    protected String description;
    @XNodeList(value="operation", type=ArrayList.class, componentType=Operation.class)
    protected ArrayList<Operation> ops;
    @XNode(value="public")
    protected boolean isPublic = true;

    public OperationChain toOperationChain(Bundle bundle) throws Exception {
        OperationChain chain = new OperationChain(this.id);
        chain.setDescription(this.description);
        chain.setPublic(this.isPublic);
        for (Operation op : this.ops) {
            OperationParameters params = chain.add(op.id);
            for (Param param : op.params) {
                param.value = param.value.trim();
                if (param.value.startsWith("expr:")) {
                    param.value = param.value.substring(5);
                    param.value = StringEscapeUtils.unescapeXml((String)param.value);
                    if (param.value.contains("@{")) {
                        params.set(param.name, Scripting.newTemplate(param.value));
                        continue;
                    }
                    params.set(param.name, Scripting.newExpression(param.value));
                    continue;
                }
                Object val = null;
                String type = param.type.toLowerCase();
                char c = type.charAt(0);
                switch (c) {
                    case 's': {
                        if (!"string".equals(type)) break;
                        val = param.value;
                        break;
                    }
                    case 'p': {
                        if (!"properties".equals(type)) break;
                        if (param.map != null && !param.map.isEmpty()) {
                            val = new Properties(param.map);
                            break;
                        }
                        val = new Properties(param.value);
                        break;
                    }
                    case 'i': {
                        if (!"integer".equals(type)) break;
                        val = Long.valueOf(param.value);
                        break;
                    }
                    case 'b': {
                        if (!"boolean".equals(type)) break;
                        val = Boolean.valueOf(param.value);
                        break;
                    }
                    case 'd': {
                        if ("document".equals(type)) {
                            if (param.value.startsWith(".")) {
                                val = Scripting.newExpression("Document.resolvePathAsRef(\"" + param.value + "\")");
                                break;
                            }
                            val = StringToDocRef.createRef(param.value);
                            break;
                        }
                        if ("documents".equals(type)) {
                            String[] ar = StringUtils.split((String)param.value, (char)',', (boolean)true);
                            DocumentRefListImpl result = new DocumentRefListImpl(ar.length);
                            for (String ref : ar) {
                                result.add((Object)StringToDocRef.createRef(ref));
                            }
                            val = result;
                            break;
                        }
                        if (!"date".equals(type)) break;
                        val = DateParser.parseW3CDateTime((String)param.value);
                        break;
                    }
                    case 'f': {
                        if (!"float".equals(type)) break;
                        val = Double.valueOf(param.value);
                        break;
                    }
                    case 'r': {
                        if (!"resource".equals(type)) break;
                        val = param.value.contains(":/") ? new URL(param.value) : bundle.getEntry(param.value);
                    }
                }
                if (val == null) {
                    val = param.value;
                }
                params.set(param.name, val);
            }
        }
        return chain;
    }

    @XObject(value="param")
    public static class Param {
        @XNode(value="@name")
        protected String name;
        @XNode(value="@type")
        protected String type = "string";
        @XContent
        protected String value;
        @XNodeMap(value="property", key="@key", type=HashMap.class, componentType=String.class, nullByDefault=true)
        protected Map<String, String> map;
    }

    @XObject(value="operation")
    public static class Operation {
        @XNode(value="@id")
        protected String id;
        @XNodeList(value="param", type=ArrayList.class, componentType=Param.class)
        protected ArrayList<Param> params;
    }
}

