/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.events;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.automation.core.events.EventHandler;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class EventRegistry
extends ContributionFragmentRegistry<EventHandler> {
    protected Map<String, List<EventHandler>> handlers = new HashMap<String, List<EventHandler>>();
    protected volatile Map<String, List<EventHandler>> lookup;

    public String getContributionId(EventHandler contrib) {
        return contrib.getChainId();
    }

    public void contributionUpdated(String id, EventHandler handler, EventHandler newOrigContrib) {
        for (String eventId : handler.getEvents()) {
            this.putEventHandler(eventId, handler);
        }
        this.lookup = null;
    }

    protected void putEventHandler(String eventId, EventHandler handler) {
        List<EventHandler> handlers = this.handlers.get(eventId);
        if (handlers == null) {
            handlers = new ArrayList<EventHandler>();
        }
        if (!handlers.contains(handler)) {
            handlers.add(handler);
        }
        this.handlers.put(eventId, handlers);
    }

    public void contributionRemoved(String id, EventHandler handler) {
        block0: for (String eventId : handler.getEvents()) {
            List<EventHandler> handlers = this.handlers.get(eventId);
            if (handlers == null) continue;
            Iterator<EventHandler> it = handlers.iterator();
            while (it.hasNext()) {
                EventHandler h = it.next();
                if (!h.chainId.equals(handler.chainId)) continue;
                it.remove();
                continue block0;
            }
        }
        this.lookup = null;
    }

    public boolean isSupportingMerge() {
        return false;
    }

    public EventHandler clone(EventHandler orig) {
        throw new UnsupportedOperationException();
    }

    public void merge(EventHandler src, EventHandler dst) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<EventHandler>> lookup() {
        Map<String, List<EventHandler>> _lookup = this.lookup;
        if (_lookup == null) {
            EventRegistry eventRegistry = this;
            synchronized (eventRegistry) {
                if (this.lookup == null) {
                    this.lookup = new HashMap<String, List<EventHandler>>(this.handlers);
                }
                _lookup = this.lookup;
            }
        }
        return _lookup;
    }
}

