/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.blob;

import java.util.HashMap;
import java.util.List;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionService;

@Operation(id="Blob.ToPDF", category="Conversion", label="Convert To PDF", description="Convert the input file to a PDF and return the new file.")
public class BlobToPDF {
    public static final String ID = "Blob.ToPDF";
    @Context
    protected ConversionService service;

    @OperationMethod
    public Blob run(DocumentModel doc) throws Exception {
        BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
        if (bh == null) {
            return null;
        }
        BlobHolder pdfBh = this.service.convertToMimeType("application/pdf", bh, new HashMap());
        Blob result = pdfBh.getBlob();
        String fname = result.getFilename();
        if (fname == null || fname.isEmpty()) {
            fname = bh.getBlob().getFilename();
            fname = fname + ".pdf";
            result.setFilename(fname);
        }
        result.setMimeType("application/pdf");
        return result;
    }

    @OperationMethod
    public Blob run(Blob blob) throws Exception {
        SimpleBlobHolder bh = new SimpleBlobHolder(blob);
        bh = this.service.convertToMimeType("application/pdf", (BlobHolder)bh, new HashMap());
        Blob result = bh.getBlob();
        this.adjustBlobName(blob, result);
        return result;
    }

    @OperationMethod
    public BlobList run(BlobList blobs) throws Exception {
        SimpleBlobHolder bh = new SimpleBlobHolder((List)blobs);
        bh = this.service.convertToMimeType("application/pdf", (BlobHolder)bh, new HashMap());
        List result = bh.getBlobs();
        int size = result.size();
        for (int i = 0; i < size; ++i) {
            this.adjustBlobName((Blob)blobs.get(i), (Blob)result.get(i));
        }
        return new BlobList(result);
    }

    protected void adjustBlobName(Blob in, Blob out) {
        String fname = in.getFilename();
        if (fname == null) {
            fname = "Unknown_" + System.identityHashCode(in);
        }
        out.setFilename(fname + ".pdf");
        out.setMimeType("application/pdf");
    }
}

