/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.document;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.security.ACP;

@Operation(id="Document.RemoveACL", category="Document", label="Remove ACL", description="Remove a named Acces Control List from the input document(s). Returns the document(s).")
public class RemoveDocumentACL {
    public static final String ID = "Document.RemoveACL";
    @Context
    protected CoreSession session;
    @Param(name="acl")
    protected String aclName;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel doc) throws Exception {
        this.deleteACL(doc.getRef());
        return this.session.getDocument(doc.getRef());
    }

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentRef doc) throws Exception {
        this.deleteACL(doc);
        return this.session.getDocument(doc);
    }

    protected void deleteACL(DocumentRef ref) throws ClientException {
        ACP acp = this.session.getACP(ref);
        acp.removeACL(this.aclName);
        acp.removeACL("inherited");
        this.session.setACP(ref, acp, true);
    }
}

