/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.execution;

import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;

@Operation(id="Context.RunDocumentOperation", category="Execution Flow", label="Run Document Chain", description="Run an operation chain which is returning a document in the current context. The input for the chain ro run is the current input of the operation. Return the output of the chain as a document.")
public class RunDocumentChain {
    public static final String ID = "Context.RunDocumentOperation";
    @Context
    protected OperationContext ctx;
    @Context
    protected AutomationService service;
    @Param(name="id")
    protected String chainId;
    @Param(name="isolate", required=false, values={"false"})
    protected boolean isolate = false;

    @OperationMethod
    public DocumentModel run(DocumentModel doc) throws Exception {
        Map<String, Object> vars = this.isolate ? new HashMap<String, Object>(this.ctx.getVars()) : this.ctx.getVars();
        OperationContext subctx = new OperationContext(this.ctx.getCoreSession(), vars);
        subctx.setInput(doc);
        return (DocumentModel)this.service.run(subctx, this.chainId);
    }

    @OperationMethod
    public DocumentModelList run(DocumentModelList docs) throws Exception {
        DocumentModelListImpl result = new DocumentModelListImpl(docs.size());
        for (DocumentModel doc : docs) {
            result.add((Object)this.run(doc));
        }
        return result;
    }
}

