/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.scripting;

import groovy.lang.Binding;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.mvel2.MVEL;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.scripting.DateWrapper;
import org.nuxeo.ecm.automation.core.scripting.DocumentWrapper;
import org.nuxeo.ecm.automation.core.scripting.Expression;
import org.nuxeo.ecm.automation.core.scripting.Functions;
import org.nuxeo.ecm.automation.core.scripting.GroovyScripting;
import org.nuxeo.ecm.automation.core.scripting.MvelExpression;
import org.nuxeo.ecm.automation.core.scripting.MvelTemplate;
import org.nuxeo.ecm.automation.core.scripting.PrincipalWrapper;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.runtime.api.Framework;

public class Scripting {
    protected static final Map<String, Script> cache = new ConcurrentHashMap<String, Script>();
    protected static final GroovyScripting gscripting = new GroovyScripting();

    public static Expression newExpression(String expr) {
        return new MvelExpression(expr);
    }

    public static Expression newTemplate(String expr) {
        return new MvelTemplate(expr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(OperationContext ctx, URL script) throws Exception {
        String key = script.toExternalForm();
        Script cs = cache.get(key);
        if (cs != null) {
            cs.eval(ctx);
            return;
        }
        String path = script.getPath();
        int p = path.lastIndexOf(46);
        if (p == -1) {
            throw new OperationException("Script files must have an extension: " + script);
        }
        String ext = path.substring(p + 1).toLowerCase();
        if ("mvel".equals(ext)) {
            InputStream in = script.openStream();
            try {
                Serializable c = MVEL.compileExpression((String)FileUtils.read((InputStream)in));
                cs = new MvelScript(c);
            }
            finally {
                in.close();
            }
        } else if (!"groovy".equals(ext)) {
            throw new OperationException("Unsupported script file: " + script + ". Only mvel and groovy scripts are supported");
        }
        cache.put(key, cs);
        cs.eval(ctx);
    }

    public static Map<String, Object> initBindings(OperationContext ctx) {
        Object input = ctx.getInput();
        HashMap<String, Object> map = new HashMap<String, Object>(ctx);
        map.put("CurrentDate", new DateWrapper());
        map.put("Context", ctx);
        if (ctx.get("WorkflowVariables") != null) {
            map.put("WorkflowVariables", ctx.get("WorkflowVariables"));
        }
        if (ctx.get("NodeVariables") != null) {
            map.put("NodeVariables", ctx.get("NodeVariables"));
        }
        map.put("This", input);
        map.put("Session", ctx.getCoreSession());
        map.put("CurrentUser", new PrincipalWrapper((NuxeoPrincipal)ctx.getPrincipal()));
        map.put("Env", Framework.getProperties());
        map.put("Fn", Functions.getInstance());
        if (input instanceof DocumentModel) {
            map.put("Document", new DocumentWrapper(ctx.getCoreSession(), (DocumentModel)input));
        }
        if (input instanceof DocumentModelList) {
            ArrayList<DocumentWrapper> docs = new ArrayList<DocumentWrapper>();
            for (DocumentModel doc : (DocumentModelList)input) {
                docs.add(new DocumentWrapper(ctx.getCoreSession(), doc));
            }
            map.put("Documents", docs);
            if (docs.size() >= 1) {
                map.put("Document", docs.get(0));
            }
        }
        return map;
    }

    public static class GroovyScript
    implements Script {
        final groovy.lang.Script c;

        public GroovyScript(String c) {
            this.c = gscripting.getScript(c, new Binding());
        }

        @Override
        public Object eval(OperationContext ctx) throws Exception {
            Binding binding = new Binding();
            for (Map.Entry<String, Object> entry : Scripting.initBindings(ctx).entrySet()) {
                binding.setVariable(entry.getKey(), entry.getValue());
            }
            this.c.setBinding(binding);
            return this.c.run();
        }
    }

    public static class MvelScript
    implements Script {
        final Serializable c;

        public static MvelScript compile(String script) {
            return new MvelScript(MVEL.compileExpression((String)script));
        }

        public MvelScript(Serializable c) {
            this.c = c;
        }

        @Override
        public Object eval(OperationContext ctx) throws Exception {
            return MVEL.executeExpression((Object)this.c, Scripting.initBindings(ctx));
        }
    }

    public static interface Script {
        public Object eval(OperationContext var1) throws Exception;
    }
}

