/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.event.jms;

import java.rmi.dgc.VMID;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.impl.EventServiceImpl;
import org.nuxeo.ecm.core.event.impl.ReconnectedEventBundleImpl;
import org.nuxeo.ecm.core.event.jms.SerializableEventBundle;

public class ReconnectedJMSEventBundle
extends ReconnectedEventBundleImpl {
    private static final Log log = LogFactory.getLog(ReconnectedJMSEventBundle.class);
    private static final long serialVersionUID = 1L;
    protected final SerializableEventBundle jmsEventBundle;

    public ReconnectedJMSEventBundle(SerializableEventBundle jmsEventBundle) {
        this.jmsEventBundle = jmsEventBundle;
    }

    @Override
    protected List<Event> getReconnectedEvents() {
        if (this.sourceEventBundle == null) {
            try {
                this.sourceEventBundle = this.jmsEventBundle.reconstructEventBundle(this.getReconnectedCoreSession(this.jmsEventBundle.getCoreInstanceName()));
            }
            catch (SerializableEventBundle.CannotReconstruct e) {
                log.error((Object)"Error while reconstructing Bundle from JMS", (Throwable)((Object)e));
                return null;
            }
        }
        return super.getReconnectedEvents();
    }

    @Override
    public String getName() {
        return this.jmsEventBundle.getEventBundleName();
    }

    @Override
    public VMID getSourceVMID() {
        return this.jmsEventBundle.getSourceVMID();
    }

    @Override
    public boolean hasRemoteSource() {
        return !this.getSourceVMID().equals(EventServiceImpl.VMID);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean comesFromJMS() {
        return true;
    }
}

