/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.event.script;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.nuxeo.ecm.core.event.script.Script;

public class FileScript
extends Script {
    protected final File file;

    public FileScript(File file) {
        this.file = file;
    }

    public FileScript(String path) {
        this(new File(path));
    }

    @Override
    public String getExtension() {
        return this.getExtension(this.file.getPath());
    }

    @Override
    public String getLocation() {
        return this.file.getAbsolutePath();
    }

    @Override
    public Reader getReader() throws IOException {
        return new FileReader(this.file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getReaderIfModified() throws IOException {
        long tm = this.file.lastModified();
        if (tm > this.lastModified) {
            FileScript fileScript = this;
            synchronized (fileScript) {
                if (tm > this.lastModified) {
                    this.lastModified = tm;
                    return new FileReader(this.file);
                }
            }
        }
        return null;
    }
}

