/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.event.script;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.nuxeo.ecm.core.event.script.Script;

public class JARFileScript
extends Script {
    protected final URL url;
    protected final File jar;

    public JARFileScript(File jar, URL url) {
        this.url = url;
        this.jar = jar;
    }

    @Override
    public String getExtension() {
        return this.getExtension(this.url.getPath());
    }

    @Override
    public String getLocation() {
        return this.url.toExternalForm();
    }

    @Override
    public Reader getReader() throws IOException {
        return new InputStreamReader(this.url.openStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getReaderIfModified() throws IOException {
        long tm = this.jar.lastModified();
        if (tm > this.lastModified) {
            JARFileScript jARFileScript = this;
            synchronized (jARFileScript) {
                if (tm > this.lastModified) {
                    this.lastModified = tm;
                    return new InputStreamReader(this.url.openStream());
                }
            }
        }
        return null;
    }
}

