/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.event.script;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.script.SimpleScriptContext;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.event.script.FakeCompiledScript;
import org.nuxeo.ecm.core.event.script.FileScript;
import org.nuxeo.ecm.core.event.script.JARFileScript;
import org.nuxeo.ecm.core.event.script.JARUrlScript;
import org.nuxeo.ecm.core.event.script.URLScript;

public abstract class Script {
    public static boolean trackChanges = true;
    public static ScriptEngineManager scripting;
    public CompiledScript script;
    public long lastModified = -1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ScriptEngineManager getScripting() {
        if (scripting != null) return scripting;
        Class<Script> clazz = Script.class;
        synchronized (Script.class) {
            scripting = new ScriptEngineManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return scripting;
        }
    }

    public static Script newScript(String location) throws Exception {
        if (location.indexOf(58) > -1) {
            return Script.newScript(new URL(location));
        }
        return new FileScript(location);
    }

    public static Script newScript(URL location) throws Exception {
        String proto = location.getProtocol();
        if (proto.equals("jar")) {
            String path = location.getPath();
            int p = path.indexOf(33);
            if (p == -1) {
                return new URLScript(location);
            }
            if ((path = path.substring(0, p)).startsWith("file:")) {
                return new JARFileScript(new File(new URI(path)), location);
            }
            return new JARUrlScript(new URL(path), location);
        }
        if (proto.equals("file")) {
            return new FileScript(new File(location.toURI()));
        }
        return new URLScript(location);
    }

    public static Script newScript(File location) {
        return new FileScript(location);
    }

    public abstract Reader getReader() throws IOException;

    public abstract Reader getReaderIfModified() throws IOException;

    public abstract String getExtension();

    public abstract String getLocation();

    protected String getExtension(String location) {
        int p = location.lastIndexOf(46);
        if (p > -1) {
            return location.substring(p + 1);
        }
        return null;
    }

    public Object run(Bindings args) throws Exception {
        if (args == null) {
            args = new SimpleBindings();
        }
        SimpleScriptContext ctx = new SimpleScriptContext();
        ctx.setBindings(args, 100);
        Object result = null;
        result = !trackChanges && this.script != null ? this.script.eval(ctx) : this.getCompiledScript().eval(ctx);
        return result;
    }

    public CompiledScript getCompiledScript() throws ScriptException {
        try {
            Reader reader;
            Reader reader2 = reader = this.script == null ? this.getReader() : this.getReaderIfModified();
            if (reader != null) {
                this.script = this.compile(reader);
            }
            return this.script;
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompiledScript compile(Reader reader) throws ScriptException {
        ScriptEngine engine = Script.getScripting().getEngineByExtension(this.getExtension());
        if (engine == null) {
            throw new ScriptException("Unknown script type: " + this.getExtension());
        }
        if (engine instanceof Compilable) {
            CompiledScript compiledScript;
            Compilable comp = (Compilable)((Object)engine);
            try {
                compiledScript = comp.compile(reader);
            }
            catch (Throwable throwable) {
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ScriptException(e);
                }
            }
            reader.close();
            return compiledScript;
        }
        return new FakeCompiledScript(engine, this);
    }

    public static void main(String[] args) throws Exception {
        URL url = new URL("jar:file:///Users/bstefanescu/work/kits/freemarker-2.3.15/lib/freemarker.jar!/freemarker/version.properties");
        System.out.println(">>" + url.getProtocol());
        System.out.println(">>" + url.getPath());
        System.out.println(">>" + FileUtils.read((InputStream)url.openStream()));
    }
}

