/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.event.tx;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventStats;
import org.nuxeo.ecm.core.event.ReconnectedEventBundle;
import org.nuxeo.ecm.core.event.impl.EventListenerDescriptor;
import org.nuxeo.ecm.core.event.impl.ReconnectedEventBundleImpl;
import org.nuxeo.ecm.core.event.tx.EventBundleTransactionHandler;
import org.nuxeo.runtime.api.Framework;

public class PostCommitSynchronousRunner {
    public static final int DEFAULT_TIME_OUT_MS = 300;
    private static final Log log = LogFactory.getLog(PostCommitSynchronousRunner.class);
    protected final List<EventListenerDescriptor> listeners;
    protected final ReconnectedEventBundle event;
    protected long timeout = 0L;

    public PostCommitSynchronousRunner(List<EventListenerDescriptor> listeners, EventBundle event, long timeout) {
        this.listeners = listeners;
        this.event = event instanceof ReconnectedEventBundle ? (ReconnectedEventBundle)event : new ReconnectedEventBundleImpl(event, listeners.toString());
        this.timeout = timeout;
    }

    public PostCommitSynchronousRunner(List<EventListenerDescriptor> listeners, EventBundle event) {
        this(listeners, event, 300L);
    }

    public void run() {
        this.runSync();
    }

    protected void handleUnfinishedThread(Thread runner) {
        log.warn((Object)"PostCommitListeners are too slow, check debug log ...");
        log.warn((Object)"Exit before the end of processing");
    }

    protected void runSync() {
        log.debug((Object)("Starting sync executor from Thread " + Thread.currentThread().getId()));
        Thread runner = new Thread(this.getExecutor());
        runner.start();
        try {
            runner.join(this.timeout);
            if (runner.isAlive()) {
                this.handleUnfinishedThread(runner);
            }
        }
        catch (InterruptedException e) {
            log.error((Object)"Exit before the end of processing", (Throwable)e);
        }
        log.debug((Object)("Terminated sync executor from Thread " + Thread.currentThread().getId()));
    }

    protected Runnable getExecutor() {
        return new MonoThreadExecutor();
    }

    protected class MonoThreadExecutor
    implements Runnable,
    Thread.UncaughtExceptionHandler {
        protected EventBundleTransactionHandler txh = new EventBundleTransactionHandler();

        protected MonoThreadExecutor() {
        }

        protected EventStats getEventStats() {
            try {
                return (EventStats)Framework.getService(EventStats.class);
            }
            catch (Exception e) {
                log.warn((Object)"Failed to lookup event stats service", (Throwable)e);
                return null;
            }
        }

        @Override
        public void run() {
            long t0 = System.currentTimeMillis();
            log.debug((Object)("Start post commit sync execution in Thread " + Thread.currentThread().getId()));
            EventStats stats = this.getEventStats();
            for (EventListenerDescriptor listener : PostCommitSynchronousRunner.this.listeners) {
                try {
                    long t1 = System.currentTimeMillis();
                    this.txh.beginNewTransaction();
                    listener.asPostCommitListener().handleEvent(PostCommitSynchronousRunner.this.event);
                    PostCommitSynchronousRunner.this.event.disconnect();
                    this.txh.commitOrRollbackTransaction();
                    if (stats != null) {
                        stats.logAsyncExec(listener, System.currentTimeMillis() - t1);
                    }
                    log.debug((Object)("End of post commit sync execution for listener " + listener.getName() + " " + (System.currentTimeMillis() - t1) + "ms"));
                }
                catch (Throwable t) {
                    log.error((Object)("Exception during post commit sync execution for listener " + listener.getName()), t);
                    PostCommitSynchronousRunner.this.event.disconnect();
                    this.txh.rollbackTransaction();
                }
            }
            log.debug((Object)("End of all post commit sync executions : " + (System.currentTimeMillis() - t0) + "ms"));
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            PostCommitSynchronousRunner.this.event.disconnect();
            this.txh.rollbackTransaction();
        }
    }
}

