/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.work;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.work.api.WorkQueueDescriptor;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class WorkQueueDescriptorRegistry
extends ContributionFragmentRegistry<WorkQueueDescriptor> {
    private static final Log log = LogFactory.getLog(WorkQueueDescriptorRegistry.class);
    protected Map<String, WorkQueueDescriptor> registry = new HashMap<String, WorkQueueDescriptor>();
    protected volatile boolean refresh;
    protected Map<String, String> categoryToQueueId = new HashMap<String, String>();

    public synchronized WorkQueueDescriptor get(String queueId) {
        return this.registry.get(queueId);
    }

    public synchronized List<String> getQueueIds() {
        return new ArrayList<String>(this.registry.keySet());
    }

    public String getContributionId(WorkQueueDescriptor contrib) {
        return contrib.id;
    }

    public void contributionUpdated(String id, WorkQueueDescriptor contrib, WorkQueueDescriptor newOrigContrib) {
        this.registry.put(id, contrib);
        this.refresh = true;
    }

    public void contributionRemoved(String id, WorkQueueDescriptor origContrib) {
        this.registry.remove(id);
        this.refresh = true;
    }

    protected synchronized void refresh() {
        for (Map.Entry<String, WorkQueueDescriptor> es : this.registry.entrySet()) {
            String queueId = es.getKey();
            for (String category : es.getValue().categories) {
                String old = this.categoryToQueueId.get("category");
                if (old != null) {
                    log.error((Object)("Work category '" + category + "' cannot be assigned to work queue '" + queueId + "' because it is already assigned to work queue '" + old + "'"));
                    continue;
                }
                this.categoryToQueueId.put(category, queueId);
            }
        }
    }

    public String getQueueId(String category) {
        if (this.refresh) {
            this.refresh();
        }
        return this.categoryToQueueId.get(category);
    }

    public WorkQueueDescriptor clone(WorkQueueDescriptor orig) {
        return orig.clone();
    }

    public void merge(WorkQueueDescriptor src, WorkQueueDescriptor dst) {
        dst.merge(src);
    }
}

