/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.work.api;

import java.io.Serializable;
import java.security.Principal;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.nuxeo.ecm.core.api.DocumentLocation;

public interface Work
extends Runnable {
    public String getCategory();

    public void beforeRun();

    @Override
    public void run();

    public void afterRun(boolean var1);

    public State getState();

    public String getTitle();

    public String getStatus();

    public long getSchedulingTime();

    public long getStartTime();

    public long getCompletionTime();

    public Progress getProgress();

    public boolean suspend();

    public boolean awaitTermination(long var1, TimeUnit var3) throws InterruptedException;

    public void setCanceled();

    public Map<String, Serializable> getData();

    public void setData(Map<String, Serializable> var1);

    public Principal getPrincipal();

    public Collection<DocumentLocation> getDocuments();

    public static class Progress {
        public static long CURRENT_INDETERMINATE = -1L;
        public static float PERCENT_INDETERMINATE = -1.0f;
        public static final Progress PROGRESS_INDETERMINATE = new Progress(PERCENT_INDETERMINATE);
        public static final Progress PROGRESS_0_PC = new Progress(0.0f);
        public static final Progress PROGRESS_100_PC = new Progress(100.0f);
        protected final float percent;
        protected final long current;
        protected final long total;

        public Progress(float percent) {
            this.percent = percent > 100.0f ? 100.0f : percent;
            this.current = CURRENT_INDETERMINATE;
            this.total = 0L;
        }

        public Progress(long current, long total) {
            this.percent = PERCENT_INDETERMINATE;
            this.current = current;
            this.total = total;
        }

        public float getPercent() {
            return this.percent;
        }

        public long getCurrent() {
            return this.current;
        }

        public long getTotal() {
            return this.total;
        }

        public boolean getIsWithPercent() {
            return this.percent != PERCENT_INDETERMINATE;
        }

        public boolean getIsWithCurrentAndTotal() {
            return this.current != CURRENT_INDETERMINATE;
        }

        public boolean getIsIndeterminate() {
            return this.percent == PERCENT_INDETERMINATE && this.current == CURRENT_INDETERMINATE;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(" + (this.percent == PERCENT_INDETERMINATE ? "?" : Float.valueOf(this.percent)) + "%, " + (this.current == CURRENT_INDETERMINATE ? "?" : Long.valueOf(this.current)) + "/" + this.total + ")";
        }
    }

    public static enum State {
        SCHEDULED,
        RUNNING,
        SUSPENDING,
        SUSPENDED,
        COMPLETED,
        FAILED,
        CANCELED;

    }
}

