/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.io.plugins;

import org.nuxeo.ecm.platform.forms.layout.api.WidgetDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetSelectOption;
import org.nuxeo.ecm.platform.forms.layout.api.converters.AbstractWidgetDefinitionConverter;
import org.nuxeo.ecm.platform.forms.layout.api.converters.LayoutConversionContext;
import org.nuxeo.ecm.platform.forms.layout.io.plugins.helpers.VocabularyHelper;

public class WidgetDirectoryItemsConverter
extends AbstractWidgetDefinitionConverter {
    public static final String DIR_NAME_PROPERTY = "directoryName";

    protected boolean isDirectoryWidget(String wType) {
        return SUPPORTED_DIR_TYPES.selectManyDirectory.name().equals(wType) || SUPPORTED_DIR_TYPES.selectOneDirectory.name().equals(wType);
    }

    public WidgetDefinition getWidgetDefinition(WidgetDefinition widgetDef, LayoutConversionContext ctx) {
        String wType = widgetDef.getType();
        if (this.isDirectoryWidget(wType)) {
            String dirName = (String)widgetDef.getProperties("any", "any").get(DIR_NAME_PROPERTY);
            if (dirName == null) {
                dirName = (String)widgetDef.getProperties("any", "edit").get(DIR_NAME_PROPERTY);
            }
            if (dirName == null) {
                dirName = (String)widgetDef.getProperties("any", "view").get(DIR_NAME_PROPERTY);
            }
            if (dirName != null) {
                WidgetDefinition clone = this.getClonedWidget(widgetDef);
                WidgetSelectOption[] selectOptions = VocabularyHelper.getVocabularySelectOptions(dirName, ctx.getLanguage()).toArray(new WidgetSelectOption[0]);
                clone.setSelectOptions(selectOptions);
                return clone;
            }
        }
        return widgetDef;
    }

    protected static enum SUPPORTED_DIR_TYPES {
        selectOneDirectory,
        selectManyDirectory;

    }
}

