/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints.pb;

import java.io.Serializable;
import java.math.BigInteger;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.constraints.cnf.Lits;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.Undoable;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.pb.constraints.pb.IDataStructurePB;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVecInt;

public abstract class WatchPbLong
implements Constr,
Undoable,
Serializable {
    private static final long serialVersionUID = 1L;
    protected double activity;
    protected long[] coefs;
    protected long degree;
    protected int[] lits;
    protected boolean learnt = false;
    protected ILits voc;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.sat4j.pb.constraints.pb.WatchPbLong");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    WatchPbLong() {
    }

    WatchPbLong(IDataStructurePB mpb) {
        int size = mpb.size();
        this.lits = new int[size];
        BigInteger[] bigCoefs = new BigInteger[size];
        mpb.buildConstraintFromMapPb(this.lits, bigCoefs);
        this.coefs = WatchPbLong.toLong(bigCoefs);
        this.degree = mpb.getDegree().longValue();
        this.sort();
    }

    WatchPbLong(int[] lits, BigInteger[] coefs, BigInteger degree) {
        this.lits = lits;
        this.coefs = WatchPbLong.toLong(coefs);
        this.degree = degree.longValue();
        this.sort();
    }

    public static long[] toLong(BigInteger[] bigValues) {
        long[] res = new long[bigValues.length];
        int i = 0;
        while (i < res.length) {
            res[i] = bigValues[i].longValue();
            ++i;
        }
        return res;
    }

    public boolean isAssertive(int dl) {
        long slack = 0L;
        int i = 0;
        while (i < this.lits.length) {
            if (!(this.coefs[i] <= 0L || this.voc.isFalsified(this.lits[i]) && this.voc.getLevel(this.lits[i]) < dl)) {
                slack += this.coefs[i];
            }
            ++i;
        }
        if ((slack -= this.degree) < 0L) {
            return false;
        }
        i = 0;
        while (i < this.lits.length) {
            if (this.coefs[i] > 0L && (this.voc.isUnassigned(this.lits[i]) || this.voc.getLevel(this.lits[i]) >= dl) && slack < this.coefs[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void calcReason(int p, IVecInt outReason) {
        int[] mlits;
        int[] nArray = mlits = this.lits;
        int n = mlits.length;
        int n2 = 0;
        while (n2 < n) {
            int q = nArray[n2];
            if (this.voc.isFalsified(q)) {
                outReason.push(q ^ 1);
            }
            ++n2;
        }
    }

    protected abstract void computeWatches() throws ContradictionException;

    protected abstract void computePropagation(UnitPropagationListener var1) throws ContradictionException;

    public int get(int i) {
        return this.lits[i];
    }

    public double getActivity() {
        return this.activity;
    }

    public void incActivity(double claInc) {
        if (this.learnt) {
            this.activity += claInc;
        }
    }

    public long slackConstraint() {
        return this.computeLeftSide() - this.degree;
    }

    public long slackConstraint(long[] theCoefs, long theDegree) {
        return this.computeLeftSide(theCoefs) - theDegree;
    }

    public long computeLeftSide(long[] theCoefs) {
        long poss = 0L;
        int i = 0;
        while (i < this.lits.length) {
            if (!this.voc.isFalsified(this.lits[i])) {
                if (!$assertionsDisabled && theCoefs[i] < 0L) {
                    throw new AssertionError();
                }
                poss += theCoefs[i];
            }
            ++i;
        }
        return poss;
    }

    public long computeLeftSide() {
        return this.computeLeftSide(this.coefs);
    }

    protected boolean isSatisfiable() {
        return this.computeLeftSide() >= this.degree;
    }

    public boolean learnt() {
        return this.learnt;
    }

    public boolean locked() {
        int[] nArray = this.lits;
        int n = this.lits.length;
        int n2 = 0;
        while (n2 < n) {
            int p = nArray[n2];
            if (this.voc.getReason(p) == this) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected static BigInteger ppcm(BigInteger a, BigInteger b) {
        return a.divide(a.gcd(b)).multiply(b);
    }

    public void rescaleBy(double d) {
        this.activity *= d;
    }

    void selectionSort(int from, int to) {
        int i = from;
        while (i < to - 1) {
            int best_i = i;
            int j = i + 1;
            while (j < to) {
                if (this.coefs[j] > this.coefs[best_i] || this.coefs[j] == this.coefs[best_i] && this.lits[j] > this.lits[best_i]) {
                    best_i = j;
                }
                ++j;
            }
            long tmp = this.coefs[i];
            this.coefs[i] = this.coefs[best_i];
            this.coefs[best_i] = tmp;
            int tmp2 = this.lits[i];
            this.lits[i] = this.lits[best_i];
            this.lits[best_i] = tmp2;
            ++i;
        }
    }

    public void setLearnt() {
        this.learnt = true;
    }

    public boolean simplify() {
        long cumul = 0L;
        int i = 0;
        while (i < this.lits.length && cumul < this.degree) {
            if (this.voc.isSatisfied(this.lits[i])) {
                cumul += this.coefs[i];
            }
            ++i;
        }
        return cumul >= this.degree;
    }

    public final int size() {
        return this.lits.length;
    }

    protected final void sort() {
        if (!$assertionsDisabled && this.lits == null) {
            throw new AssertionError();
        }
        if (this.coefs.length > 0) {
            this.sort(0, this.size());
            long buffInt = this.coefs[0];
            int i = 1;
            while (i < this.coefs.length) {
                if (!$assertionsDisabled && buffInt < this.coefs[i]) {
                    throw new AssertionError();
                }
                buffInt = this.coefs[i];
                ++i;
            }
        }
    }

    protected final void sort(int from, int to) {
        int width = to - from;
        if (width <= 15) {
            this.selectionSort(from, to);
        } else {
            int indPivot = width / 2 + from;
            long pivot = this.coefs[indPivot];
            int litPivot = this.lits[indPivot];
            int i = from - 1;
            int j = to;
            while (true) {
                if (this.coefs[++i] > pivot || this.coefs[i] == pivot && this.lits[i] > litPivot) {
                    continue;
                }
                while (pivot > this.coefs[--j] || this.coefs[j] == pivot && this.lits[j] < litPivot) {
                }
                if (i >= j) break;
                long tmp = this.coefs[i];
                this.coefs[i] = this.coefs[j];
                this.coefs[j] = tmp;
                int tmp2 = this.lits[i];
                this.lits[i] = this.lits[j];
                this.lits[j] = tmp2;
            }
            this.sort(from, i);
            this.sort(i, to);
        }
    }

    public String toString() {
        StringBuffer stb = new StringBuffer();
        if (this.lits.length > 0) {
            int i = 0;
            while (i < this.lits.length) {
                stb.append(" + ");
                stb.append(this.coefs[i]);
                stb.append(".");
                stb.append(Lits.toString((int)this.lits[i]));
                stb.append("[");
                stb.append(this.voc.valueToString(this.lits[i]));
                stb.append("@");
                stb.append(this.voc.getLevel(this.lits[i]));
                stb.append("]");
                stb.append(" ");
                ++i;
            }
            stb.append(">= ");
            stb.append(this.degree);
        }
        return stb.toString();
    }

    public void assertConstraint(UnitPropagationListener s) {
        long tmp = this.slackConstraint();
        int i = 0;
        while (i < this.lits.length) {
            if (this.voc.isUnassigned(this.lits[i]) && tmp < this.coefs[i]) {
                boolean ret = s.enqueue(this.lits[i], (Constr)this);
                if (!$assertionsDisabled && !ret) {
                    throw new AssertionError();
                }
            }
            ++i;
        }
    }

    public void register() {
        block3: {
            if (!$assertionsDisabled && !this.learnt) {
                throw new AssertionError();
            }
            try {
                this.computeWatches();
            }
            catch (ContradictionException contradictionException) {
                System.out.println(this);
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    public int[] getLits() {
        int[] litsBis = new int[this.lits.length];
        System.arraycopy(this.lits, 0, litsBis, 0, this.lits.length);
        return litsBis;
    }

    public ILits getVocabulary() {
        return this.voc;
    }

    public IVecInt computeAnImpliedClause() {
        long cptCoefs = 0L;
        int index = this.coefs.length;
        while (cptCoefs > this.degree && index > 0) {
            cptCoefs += this.coefs[--index];
        }
        if (index > 0 && index < this.size() / 2) {
            VecInt literals = new VecInt(index);
            int j = 0;
            while (j <= index) {
                literals.push(this.lits[j]);
                ++j;
            }
            return literals;
        }
        return null;
    }

    public boolean coefficientsEqualToOne() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object pb) {
        if (pb == null) {
            return false;
        }
        try {
            WatchPbLong wpb = (WatchPbLong)pb;
            if (this.degree != wpb.degree || this.coefs.length != wpb.coefs.length || this.lits.length != wpb.lits.length) {
                return false;
            }
            int ilit = 0;
            while (true) {
                if (ilit >= this.coefs.length) {
                    return true;
                }
                int lit = this.lits[ilit];
                boolean ok = false;
                int ilit2 = 0;
                while (ilit2 < this.coefs.length) {
                    if (wpb.lits[ilit2] == lit) {
                        if (wpb.coefs[ilit2] != this.coefs[ilit]) {
                            return false;
                        }
                        ok = true;
                        break;
                    }
                    ++ilit2;
                }
                if (!ok) {
                    return false;
                }
                ++ilit;
            }
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        long sum = 0L;
        int[] nArray = this.lits;
        int n = this.lits.length;
        int n2 = 0;
        while (n2 < n) {
            int p = nArray[n2];
            sum += (long)p;
            ++n2;
        }
        return (int)sum / this.lits.length;
    }

    public void forwardActivity(double claInc) {
        if (!this.learnt) {
            this.activity += claInc;
        }
    }

    public void remove(UnitPropagationListener upl) {
    }

    public boolean propagate(UnitPropagationListener s, int p) {
        return false;
    }

    public void undo(int p) {
    }

    public boolean canBePropagatedMultipleTimes() {
        return true;
    }
}

