/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.impl;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.directory.BaseSession;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.api.DirectoryClient;
import org.nuxeo.ecm.directory.api.DirectoryManager;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.runtime.api.Framework;

public class DirectoryClientImpl
extends BaseSession
implements DirectoryClient {
    private static final long serialVersionUID = -1170479958816244690L;
    private static final Log log = LogFactory.getLog(DirectoryClientImpl.class);
    private final long sessionId;
    private transient DirectoryManager manager;

    public DirectoryClientImpl(long sessionId) {
        this.sessionId = sessionId;
    }

    private DirectoryManager getDirectoryManager() {
        if (this.manager == null) {
            try {
                this.manager = (DirectoryManager)Framework.getService(DirectoryService.class);
            }
            catch (Exception e) {
                log.error((Object)"Can't get DirectoryService", (Throwable)e);
                return null;
            }
        }
        return this.manager;
    }

    @Override
    public long getSessionId() {
        return this.sessionId;
    }

    @Override
    public boolean authenticate(String username, String password) throws DirectoryException {
        return this.getDirectoryManager().authenticate(this.sessionId, username, password);
    }

    @Override
    public void close() throws DirectoryException {
        this.getDirectoryManager().close(this.sessionId);
    }

    @Override
    public void commit() throws DirectoryException {
        this.getDirectoryManager().commit(this.sessionId);
    }

    @Override
    public DocumentModel createEntry(Map<String, Object> fieldMap) throws DirectoryException {
        return this.getDirectoryManager().createEntry(this.sessionId, fieldMap);
    }

    @Override
    public void deleteEntry(DocumentModel docModel) throws DirectoryException {
        this.getDirectoryManager().deleteEntry(this.sessionId, docModel);
    }

    @Override
    public void deleteEntry(String id) throws DirectoryException {
        this.getDirectoryManager().deleteEntry(this.sessionId, id);
    }

    @Override
    public void deleteEntry(String id, Map<String, String> map) throws DirectoryException {
        this.getDirectoryManager().deleteEntry(this.sessionId, id, map);
    }

    @Override
    public DocumentModelList getEntries() throws DirectoryException {
        return this.getDirectoryManager().getEntries(this.sessionId);
    }

    @Override
    public DocumentModel getEntry(String id) throws DirectoryException {
        return this.getDirectoryManager().getEntry(this.sessionId, id);
    }

    @Override
    public DocumentModel getEntry(String id, boolean fetchReferences) throws DirectoryException {
        return this.getDirectoryManager().getEntry(this.sessionId, id, fetchReferences);
    }

    @Override
    public String getIdField() throws DirectoryException {
        return this.getDirectoryManager().getIdField(this.sessionId);
    }

    @Override
    public String getPasswordField() throws DirectoryException {
        return this.getDirectoryManager().getPasswordField(this.sessionId);
    }

    @Override
    public List<String> getProjection(Map<String, Serializable> filter, String columnName) throws DirectoryException {
        return this.getDirectoryManager().getProjection(this.sessionId, filter, columnName);
    }

    @Override
    public List<String> getProjection(Map<String, Serializable> filter, Set<String> fulltext, String columnName) throws DirectoryException {
        return this.getDirectoryManager().getProjection(this.sessionId, filter, columnName);
    }

    @Override
    public boolean isAuthenticating() throws DirectoryException {
        return this.getDirectoryManager().isAuthenticating(this.sessionId);
    }

    @Override
    public boolean isReadOnly() throws DirectoryException {
        return this.getDirectoryManager().isReadOnly(this.sessionId);
    }

    @Override
    public DocumentModelList query(Map<String, Serializable> filter) throws DirectoryException {
        return this.getDirectoryManager().query(this.sessionId, filter);
    }

    @Override
    public DocumentModelList query(Map<String, Serializable> filter, Set<String> fulltext) throws DirectoryException {
        return this.getDirectoryManager().query(this.sessionId, filter, fulltext);
    }

    @Override
    public DocumentModelList query(Map<String, Serializable> filter, Set<String> fulltext, Map<String, String> orderBy) throws DirectoryException {
        return this.getDirectoryManager().query(this.sessionId, filter, fulltext, orderBy);
    }

    @Override
    public DocumentModelList query(Map<String, Serializable> filter, Set<String> fulltext, Map<String, String> orderBy, boolean fetchReferences) throws DirectoryException {
        return this.getDirectoryManager().query(this.sessionId, filter, fulltext, orderBy, fetchReferences);
    }

    @Override
    public void rollback() throws DirectoryException {
        this.getDirectoryManager().rollback(this.sessionId);
    }

    @Override
    public void updateEntry(DocumentModel docModel) throws DirectoryException {
        this.getDirectoryManager().updateEntry(this.sessionId, docModel);
    }

    @Override
    public DocumentModel createEntry(DocumentModel entry) throws ClientException {
        return this.getDirectoryManager().createEntry(this.sessionId, entry);
    }

    @Override
    public boolean hasEntry(String id) throws ClientException {
        return this.getDirectoryManager().hasEntry(this.sessionId, id);
    }
}

