/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.jaxrs.servlet.config;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.webengine.jaxrs.servlet.FilterSet;
import org.nuxeo.ecm.webengine.jaxrs.servlet.config.FilterDescriptor;
import org.nuxeo.ecm.webengine.jaxrs.servlet.mapping.Path;
import org.nuxeo.ecm.webengine.jaxrs.servlet.mapping.PathMatcher;

@XObject(value="filters")
public class FilterSetDescriptor {
    @XNode(value="@id")
    protected String id;
    @XNode(value="@target")
    protected String targetServlet;
    @XNodeList(value="filter", type=ArrayList.class, componentType=FilterDescriptor.class, nullByDefault=false)
    protected ArrayList<FilterDescriptor> filters;
    private PathMatcher path;

    @XNode(value="@pathInfo")
    public void setPathInfo(String pathInfo) {
        this.path = PathMatcher.compile(pathInfo);
    }

    public PathMatcher getPath() {
        return this.path;
    }

    public List<FilterDescriptor> getFilters() throws Exception {
        return this.filters;
    }

    public FilterSet getFilterSet() {
        return new FilterSet(this);
    }

    public boolean matches(String pathInfo) {
        if (this.path == null) {
            return true;
        }
        if (pathInfo == null || pathInfo.length() == 0) {
            pathInfo = "/";
        }
        return this.path.matches(pathInfo);
    }

    public boolean matches(Path pathInfo) {
        if (this.path == null) {
            return true;
        }
        return this.path.matches(pathInfo);
    }

    public String getId() {
        return this.id;
    }

    public String getTargetServlet() {
        return this.targetServlet;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.id != null) {
            buf.append(this.id).append("@").append(this.targetServlet).append(": ");
        }
        String p = this.path == null ? "/**" : this.path.toString();
        buf.append(p).append(" ").append(this.filters);
        return buf.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FilterSetDescriptor) {
            String id = ((FilterSetDescriptor)obj).id;
            if (id == null && this.id == null) {
                return super.equals(obj);
            }
            if (id != null) {
                return id.equals(this.id);
            }
        }
        return false;
    }
}

