/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.jaxrs.servlet.config;

import java.net.URL;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.webengine.jaxrs.servlet.config.BundleResourceResolver;
import org.nuxeo.ecm.webengine.jaxrs.servlet.config.FileResourceResolver;
import org.nuxeo.ecm.webengine.jaxrs.servlet.config.ResourceResolver;
import org.osgi.framework.Bundle;

@XObject(value="resources")
public class ResourcesDescriptor {
    @XNode(value="@servlet")
    protected String servlet;
    @XNode(value="@path")
    protected String path;
    private Bundle bundle;
    private String id;
    private ResourceResolver resolver;

    void setBundle(Bundle bundle) {
        this.bundle = bundle;
        this.resolver = this.path.startsWith("file:") ? new FileResourceResolver(this.path.substring("file:".length())) : new BundleResourceResolver(bundle, this.path);
        this.id = bundle.getSymbolicName() + ":" + this.servlet + ":" + this.path;
    }

    public void setResolver(ResourceResolver resolver) {
        this.resolver = resolver;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public String getPath() {
        return this.path;
    }

    public String getServlet() {
        return this.servlet;
    }

    public String getId() {
        return this.id;
    }

    public URL getResource(String name) {
        return this.resolver.getResource(name);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ResourcesDescriptor) {
            return this.id.equals(((ResourcesDescriptor)obj).id);
        }
        return false;
    }

    public String toString() {
        return this.id;
    }
}

