/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.impl.blob;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Vector;
import org.nuxeo.ecm.core.api.impl.blob.AbstractBlob;
import org.nuxeo.ecm.core.api.impl.blob.ByteArrayBlob;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;

public abstract class StreamBlob
extends AbstractBlob {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytes(InputStream in) throws IOException {
        Vector<byte[]> v = new Vector<byte[]>();
        byte[] buffer = new byte[65536];
        int w = 0;
        try {
            int len;
            int read = 0;
            do {
                if ((len = 65536 - (w += read)) > 0) continue;
                v.add(buffer);
                buffer = new byte[65536];
                len = 65536;
                w = 0;
            } while ((read = in.read(buffer, w, len)) != -1);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        byte[] ret = new byte[v.size() * 65536 + w];
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            byte[] tmp = (byte[])v.get(i);
            System.arraycopy(tmp, 0, ret, i * 65536, 65536);
        }
        System.arraycopy(buffer, 0, ret, v.size() * 65536, w);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytes(Reader reader) throws IOException {
        Vector<char[]> v = new Vector<char[]>();
        char[] buffer = new char[65536];
        int w = 0;
        try {
            int len;
            int read = 0;
            do {
                if ((len = 65536 - (w += read)) > 0) continue;
                v.add(buffer);
                buffer = new char[65536];
                len = 65536;
                w = 0;
            } while ((read = reader.read(buffer, w, len)) != -1);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        byte[] ret = new byte[v.size() * 65536 + w];
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            char[] tmp = (char[])v.get(i);
            System.arraycopy(tmp, 0, ret, i * 65536, 65536);
        }
        System.arraycopy(buffer, 0, ret, v.size() * 65536, w);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readString(Reader reader) throws IOException {
        StringBuilder sb = new StringBuilder(65536);
        try {
            int read;
            char[] buffer = new char[65536];
            while ((read = reader.read(buffer, 0, 65536)) != -1) {
                sb.append(buffer, 0, read);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return sb.toString();
    }

    @Override
    public byte[] getByteArray() throws IOException {
        InputStream in = this.getStream();
        if (in == null || in.available() == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        return StreamBlob.readBytes(in);
    }

    @Override
    public String getString() throws IOException {
        Reader reader = this.getReader();
        if (reader == null || reader == EMPTY_READER) {
            return "";
        }
        return StreamBlob.readString(reader);
    }

    @Override
    public Reader getReader() throws IOException {
        InputStream in = this.getStream();
        if (in == null || in.available() == 0) {
            return EMPTY_READER;
        }
        String enc = this.getEncoding();
        return enc == null ? new InputStreamReader(in) : new InputStreamReader(in, enc);
    }

    @Override
    public long getLength() {
        return -1L;
    }

    public ByteArrayBlob asByteArrayBlob() throws IOException {
        return new ByteArrayBlob(this.getByteArray(), this.getMimeType(), this.getEncoding());
    }

    public StringBlob asStringBlob() throws IOException {
        return new StringBlob(this.getString(), this.getMimeType(), this.getEncoding());
    }
}

