/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.user.center.profile;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.international.LocaleSelector;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.user.center.profile.UserProfileService;
import org.nuxeo.ecm.webapp.security.UserManagementActions;
import org.nuxeo.runtime.api.Framework;

@Name(value="userProfileActions")
@Scope(value=ScopeType.CONVERSATION)
public class UserProfileActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String PROFILE_VIEW_MODE = "view";
    public static final String PROFILE_EDIT_MODE = "edit";
    public static final String PROFILE_EDIT_PASSWORD_MODE = "editPassword";
    protected transient UserProfileService userProfileService;
    @In(create=true)
    protected transient UserManagementActions userManagementActions;
    @In(create=true)
    protected NuxeoPrincipal currentUser;
    @In(create=true)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true)
    protected transient LocaleSelector localeSelector;
    protected String mode = "view";
    protected DocumentModel userProfileDocument;

    public void updateUser() throws ClientException {
        this.userManagementActions.updateUser();
        if (this.userProfileDocument != null) {
            this.documentManager.saveDocument(this.userProfileDocument);
            this.documentManager.save();
        }
        this.mode = PROFILE_VIEW_MODE;
    }

    public String getMode() throws ClientException {
        return this.mode;
    }

    public boolean getCanEdit() throws ClientException {
        return this.userManagementActions.getAllowEditUser() && this.userManagementActions.isNotReadOnly();
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public DocumentModel getCurrentUserModel() {
        DocumentModel currentUserModel = this.currentUser.getModel();
        this.userManagementActions.setSelectedUser(currentUserModel);
        return currentUserModel;
    }

    public DocumentModel getUserProfileDocument() throws ClientException {
        this.getCurrentUserModel();
        if (this.userProfileDocument == null) {
            String currentLocale;
            this.userProfileDocument = this.getUserProfileService().getUserProfileDocument(this.documentManager);
            String locale = (String)((Object)this.userProfileDocument.getPropertyValue("userprofile:locale"));
            if (StringUtils.isEmpty((String)locale) && !StringUtils.isEmpty((String)(currentLocale = this.localeSelector.getLocaleString()))) {
                this.userProfileDocument.setPropertyValue("userprofile:locale", (Serializable)((Object)currentLocale));
            }
        }
        return this.userProfileDocument;
    }

    public DocumentModel getUserProfileDocument(String userName) throws ClientException {
        return this.getUserProfileService().getUserProfileDocument(userName, this.documentManager);
    }

    public DocumentModel getUserProfile() throws ClientException {
        return this.getUserProfileService().getUserProfile(this.getCurrentUserModel(), this.documentManager);
    }

    public DocumentModel getSelectedUserProfile() throws ClientException {
        DocumentModel selectedUser = this.userManagementActions.getSelectedUser();
        if (selectedUser == null) {
            return null;
        }
        return this.getUserProfileService().getUserProfile(selectedUser, this.documentManager);
    }

    protected UserProfileService getUserProfileService() throws ClientException {
        if (this.userProfileService == null) {
            try {
                this.userProfileService = (UserProfileService)Framework.getService(UserProfileService.class);
            }
            catch (Exception e) {
                throw new ClientException("Failed to get UserProfileService", (Throwable)e);
            }
        }
        return this.userProfileService;
    }
}

