/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.editor;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.theme.editor.FieldProperty;
import org.nuxeo.theme.elements.Element;
import org.nuxeo.theme.properties.FieldIO;
import org.nuxeo.theme.properties.FieldInfo;
import org.nuxeo.theme.properties.OrderedProperties;
import org.nuxeo.theme.themes.ThemeIOException;

public class Utils {
    private static final Log log = LogFactory.getLog(Utils.class);
    private static final String CSS_STYLE_CATEGORIES = "/nxthemes/editor/styles/categories.properties";
    private static final String STYLE_PREVIEW_CATEGORIES = "/nxthemes/editor/styles/preview-categories.properties";
    private static final Properties cssStyleCategories = new OrderedProperties();
    private static final Properties stylePreviewCategories = new Properties();

    private Utils() {
    }

    public static List<FieldProperty> getPropertiesOf(Element element) {
        ArrayList<FieldProperty> fieldProperties = new ArrayList<FieldProperty>();
        if (element == null) {
            return fieldProperties;
        }
        Properties properties = new Properties();
        try {
            properties = FieldIO.dumpFieldsToProperties((Object)element);
        }
        catch (ThemeIOException e) {
            log.error((Object)("Failed to obtain properties of element: " + element.computeXPath()), (Throwable)e);
            return fieldProperties;
        }
        if (properties == null) {
            return fieldProperties;
        }
        Class<?> c = element.getClass();
        Enumeration<?> names = properties.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = properties.getProperty(name);
            FieldInfo fieldInfo = FieldIO.getFieldInfo(c, (String)name);
            if (fieldInfo == null) continue;
            fieldProperties.add(new FieldProperty(name, value.trim(), fieldInfo));
        }
        return fieldProperties;
    }

    public static Properties getCssStyleCategories() {
        return cssStyleCategories;
    }

    public static Properties getStylePreviewCategories() {
        return stylePreviewCategories;
    }

    static {
        org.nuxeo.theme.Utils.loadProperties((Properties)cssStyleCategories, (String)CSS_STYLE_CATEGORIES);
        org.nuxeo.theme.Utils.loadProperties((Properties)stylePreviewCategories, (String)STYLE_PREVIEW_CATEGORIES);
    }
}

