/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.editor.filters;

import java.util.regex.Pattern;
import org.nuxeo.theme.elements.Element;
import org.nuxeo.theme.elements.PageElement;
import org.nuxeo.theme.rendering.RenderingInfo;
import org.nuxeo.theme.rendering.StandaloneFilter;

public final class CreateInitialSection
extends StandaloneFilter {
    static final Pattern firstTagPattern = Pattern.compile("<(.*?)>", 32);
    static final Pattern otherTagsPattern = Pattern.compile("<.*?>(.*)", 32);

    public RenderingInfo process(RenderingInfo info, boolean cache) {
        Element element = info.getElement();
        if (!(element instanceof PageElement)) {
            return info;
        }
        String viewMode = info.getViewMode();
        if (!"layout".equals(viewMode)) {
            return info;
        }
        StringBuilder html = new StringBuilder();
        if (element.hasChildren()) {
            return info;
        }
        html.append("<a href=\"javascript:void(0)\" class=\"nxthemesAddSection\" title=\"Add a section\"><div sectionid=\"").append(info.getElement().getUid().toString()).append("\"> Add a section</div></a>");
        info.setMarkup(html.toString());
        return info;
    }
}

