/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.remoting.gwt;

import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.server.rpc.impl.ServerSerializationStreamReader;
import com.google.gwt.user.server.rpc.impl.ServerSerializationStreamWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.remoting.gwt.GWTService;

@Scope(value=ScopeType.APPLICATION)
@Name(value="org.jboss.seam.remoting.gwt.gwtRemoteService")
@Install(precedence=0, classDependencies={"com.google.gwt.user.client.rpc.RemoteService"})
@BypassInterceptors
public class GWT14Service
extends GWTService {
    private static final String SERIALIZATION_POLICY_PROVIDER_CLASS = "com.google.gwt.user.server.rpc.SerializationPolicyProvider";
    private static final String SERIALIZATION_POLICY_CLASS = "com.google.gwt.user.server.rpc.SerializationPolicy";
    private static final String LEGACY_SERIALIZATION_POLICY_CLASS = "com.google.gwt.user.server.rpc.impl.LegacySerializationPolicy";
    private Constructor streamReaderConstructor;
    private Constructor streamWriterConstructor;
    private Object legacySerializationPolicy;

    @Create
    public void startup() throws Exception {
        try {
            log.trace((Object)"GWT14Service starting up");
            Class<?> policyProviderClass = Class.forName(SERIALIZATION_POLICY_PROVIDER_CLASS);
            Class<?> serializationPolicyClass = Class.forName(SERIALIZATION_POLICY_CLASS);
            this.streamReaderConstructor = ServerSerializationStreamReader.class.getConstructor(ClassLoader.class, policyProviderClass);
            this.streamWriterConstructor = ServerSerializationStreamWriter.class.getConstructor(serializationPolicyClass);
            Class<?> legacySerializationPolicyClass = Class.forName(LEGACY_SERIALIZATION_POLICY_CLASS);
            Method m = legacySerializationPolicyClass.getDeclaredMethod("getInstance", new Class[0]);
            this.legacySerializationPolicy = m.invoke(null, new Object[0]);
        }
        catch (Exception ex) {
            log.error((Object)"Error initializing GWT14Service.  Please ensure the GWT 1.4 libraries are in the classpath.");
            throw ex;
        }
    }

    protected String createResponse(ServerSerializationStreamWriter stream, Class responseType, Object responseObj, boolean isException) {
        stream.prepareToWrite();
        if (responseType != Void.TYPE) {
            try {
                stream.serializeValue(responseObj, responseType);
            }
            catch (SerializationException e) {
                responseObj = e;
                isException = true;
            }
        }
        return (isException ? "//EX" : "//OK") + stream.toString();
    }

    public ServerSerializationStreamReader getStreamReader() {
        try {
            return (ServerSerializationStreamReader)this.streamReaderConstructor.newInstance(Thread.currentThread().getContextClassLoader(), null);
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to create stream reader", ex);
        }
    }

    public ServerSerializationStreamWriter getStreamWriter() {
        try {
            return (ServerSerializationStreamWriter)this.streamWriterConstructor.newInstance(this.legacySerializationPolicy);
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to create stream writer", ex);
        }
    }
}

