/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.CoreServiceFactoryDescriptor;
import org.nuxeo.ecm.core.CoreServiceOrphanVersionRemovalFilterDescriptor;
import org.nuxeo.ecm.core.CoreServicePolicyDescriptor;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSessionFactory;
import org.nuxeo.ecm.core.versioning.DefaultVersionRemovalPolicy;
import org.nuxeo.ecm.core.versioning.OrphanVersionRemovalFilter;
import org.nuxeo.ecm.core.versioning.VersionRemovalPolicy;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Extension;

public class CoreService
extends DefaultComponent {
    private static final Log log = LogFactory.getLog(CoreService.class);
    private ComponentContext context;
    private VersionRemovalPolicy versionRemovalPolicy;
    private List<OrphanVersionRemovalFilter> orphanVersionRemovalFilters = new ArrayList<OrphanVersionRemovalFilter>();

    public List<OrphanVersionRemovalFilter> getOrphanVersionRemovalFilters() {
        return this.orphanVersionRemovalFilters;
    }

    public VersionRemovalPolicy getVersionRemovalPolicy() {
        if (this.versionRemovalPolicy == null) {
            this.versionRemovalPolicy = new DefaultVersionRemovalPolicy();
        }
        return this.versionRemovalPolicy;
    }

    public void activate(ComponentContext context) {
        this.context = context;
    }

    public void deactivate(ComponentContext context) {
        this.context = null;
    }

    public void registerExtension(Extension extension) {
        String point = extension.getExtensionPoint();
        if ("sessionFactory".equals(point)) {
            for (Object contrib : extension.getContributions()) {
                if (contrib instanceof CoreServiceFactoryDescriptor) {
                    this.registerSessionFactory((CoreServiceFactoryDescriptor)contrib);
                    continue;
                }
                log.error((Object)("Invalid contribution to extension point 'sessionFactory': " + contrib.getClass().getName()));
            }
        } else if ("versionRemovalPolicy".equals(point)) {
            for (Object contrib : extension.getContributions()) {
                if (contrib instanceof CoreServicePolicyDescriptor) {
                    this.registerVersionRemovalPolicy((CoreServicePolicyDescriptor)contrib);
                    continue;
                }
                log.error((Object)("Invalid contribution to extension point 'versionRemovalPolicy': " + contrib.getClass().getName()));
            }
        } else if ("orphanVersionRemovalFilter".equals(point)) {
            for (Object contrib : extension.getContributions()) {
                if (contrib instanceof CoreServiceOrphanVersionRemovalFilterDescriptor) {
                    this.registerOrphanVersionRemovalFilter((CoreServiceOrphanVersionRemovalFilterDescriptor)contrib);
                    continue;
                }
                log.error((Object)("Invalid contribution to extension point 'orphanVersionRemovalFilter': " + contrib.getClass().getName()));
            }
        } else {
            log.error((Object)("Unknown extension point: " + point));
        }
    }

    public void unregisterExtension(Extension extension) {
    }

    protected void registerSessionFactory(CoreServiceFactoryDescriptor desc) {
        String klass = desc.getKlass();
        try {
            CoreSessionFactory factory = (CoreSessionFactory)this.context.getRuntimeContext().loadClass(klass).newInstance();
            CoreInstance.getInstance().initialize(factory);
        }
        catch (Exception e) {
            log.error((Object)("Failed to instantiate sessionFactory: " + klass), (Throwable)e);
        }
    }

    private void registerVersionRemovalPolicy(CoreServicePolicyDescriptor desc) {
        String klass = desc.getKlass();
        try {
            this.versionRemovalPolicy = (VersionRemovalPolicy)this.context.getRuntimeContext().loadClass(klass).newInstance();
        }
        catch (Exception e) {
            log.error((Object)("Failed to instantiate versionRemovalPolicy: " + klass), (Throwable)e);
        }
    }

    private void registerOrphanVersionRemovalFilter(CoreServiceOrphanVersionRemovalFilterDescriptor desc) {
        String klass = desc.getKlass();
        try {
            this.orphanVersionRemovalFilters.add((OrphanVersionRemovalFilter)this.context.getRuntimeContext().loadClass(klass).newInstance());
        }
        catch (Exception e) {
            log.error((Object)("Failed to instantiate versionRemovalPolicy: " + klass), (Throwable)e);
        }
    }
}

