/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.model;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import javax.transaction.xa.XAResource;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.VersionModel;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.model.Repository;
import org.nuxeo.ecm.core.query.Query;
import org.nuxeo.ecm.core.query.QueryException;
import org.nuxeo.ecm.core.query.QueryFilter;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.security.SecurityManager;

public interface Session {
    public static final String USER_NAME = "username";

    public long getSessionId();

    public String getUserSessionId();

    public Repository getRepository();

    public Map<String, Serializable> getSessionContext();

    public Query createQuery(String var1, String var2, String ... var3) throws QueryException;

    public Query createQuery(String var1, Query.Type var2, String ... var3) throws QueryException;

    public IterableQueryResult queryAndFetch(String var1, String var2, QueryFilter var3, Object ... var4) throws QueryException;

    public SchemaManager getTypeManager();

    public SecurityManager getSecurityManager();

    public XAResource getXAResource();

    public void save() throws DocumentException;

    public void cancel() throws DocumentException;

    public boolean isLive();

    public void close() throws DocumentException;

    public void dispose();

    public Document resolvePath(String var1) throws DocumentException;

    public Document getDocumentByUUID(String var1) throws DocumentException;

    public Document getRootDocument() throws DocumentException;

    public Document getNullDocument() throws DocumentException;

    public Document copy(Document var1, Document var2, String var3) throws DocumentException;

    public Document move(Document var1, Document var2, String var3) throws DocumentException;

    public InputStream getDataStream(String var1) throws DocumentException;

    public Document createProxy(Document var1, Document var2) throws DocumentException;

    public Collection<Document> getProxies(Document var1, Document var2) throws DocumentException;

    public void setProxyTarget(Document var1, Document var2) throws DocumentException;

    public Document importDocument(String var1, Document var2, String var3, String var4, Map<String, Serializable> var5) throws DocumentException;

    public Document getVersion(String var1, VersionModel var2) throws DocumentException;
}

