/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.Serializable;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.BaseProperty;
import org.nuxeo.ecm.core.storage.sql.CollectionFragment;
import org.nuxeo.ecm.core.storage.sql.PropertyType;

public class CollectionProperty
extends BaseProperty {
    private final CollectionFragment fragment;

    public CollectionProperty(String name, PropertyType type, boolean readonly, CollectionFragment fragment) {
        super(name, type, readonly);
        this.fragment = fragment;
    }

    public Serializable[] getValue() throws StorageException {
        return this.fragment.get();
    }

    public String[] getStrings() throws StorageException {
        switch (this.type) {
            case ARRAY_STRING: {
                Object[] res = this.fragment.get();
                if (res.length == 0) {
                    res = new String[]{};
                }
                return (String[])res;
            }
        }
        throw new UnsupportedOperationException("Not implemented: " + (Object)((Object)this.type));
    }

    public void setValue(Object[] value) throws StorageException {
        this.checkWritable();
        try {
            this.fragment.set(this.type.normalize(value));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("item of list property '" + this.name + "': " + e.getMessage());
        }
    }
}

