/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.output.NullOutputStream;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.storage.sql.AbstractBinaryManager;
import org.nuxeo.ecm.core.storage.sql.Binary;
import org.nuxeo.ecm.core.storage.sql.BinaryManagerStreamSupport;
import org.nuxeo.ecm.core.storage.sql.LocalBinaryManager;
import org.nuxeo.runtime.services.streaming.FileSource;

public class DefaultBinaryManager
extends LocalBinaryManager
implements BinaryManagerStreamSupport {
    public DefaultBinaryManager() {
        if (!(this.getBinaryScrambler() instanceof AbstractBinaryManager.NullBinaryScrambler)) {
            throw new IllegalStateException("DefaultBinaryManager cannot be used with a binary scrambler");
        }
    }

    @Override
    public Binary getBinary(FileSource source) throws IOException {
        String digest = this.storeAndDigest(source);
        File file = this.getFileForDigest(digest, false);
        return this.getBinaryScrambler().getUnscrambledBinary(file, digest, this.repositoryName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String storeAndDigest(FileSource source) throws IOException {
        String digest;
        File sourceFile = source.getFile();
        InputStream in = source.getStream();
        NullOutputStream out = new NullOutputStream();
        try {
            digest = this.storeAndDigest(in, (OutputStream)out);
        }
        finally {
            in.close();
            out.close();
        }
        File digestFile = this.getFileForDigest(digest, true);
        if (!sourceFile.renameTo(digestFile)) {
            FileUtils.copy((File)sourceFile, (File)digestFile);
            sourceFile.delete();
        }
        source.setFile(digestFile);
        return digest;
    }
}

