/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.file.FileCache;
import org.nuxeo.ecm.core.storage.sql.Binary;
import org.nuxeo.runtime.services.streaming.FileSource;
import org.nuxeo.runtime.services.streaming.StreamSource;

public abstract class LazyBinary
extends Binary {
    private static final Log log = LogFactory.getLog(LazyBinary.class);
    private static final long serialVersionUID = 1L;
    protected static final String LEN_DIGEST_SUFFIX = "-len";
    protected final FileCache fileCache;
    protected boolean hasLength;

    public LazyBinary(String digest, FileCache fileCache) {
        super(digest);
        this.fileCache = fileCache;
    }

    @Override
    public InputStream getStream() throws IOException {
        if (this.file == null) {
            this.file = this.fileCache.getFile(this.digest);
            if (this.file == null) {
                File tmp = this.fileCache.getTempFile();
                if (this.fetchFile(tmp)) {
                    this.file = this.fileCache.putFile(this.digest, tmp);
                } else {
                    tmp.delete();
                }
            }
            if (this.file != null) {
                this.length = this.file.length();
                this.hasLength = true;
            }
        }
        return this.file == null ? null : new FileInputStream(this.file);
    }

    @Override
    public StreamSource getStreamSource() {
        if (this.file == null) {
            this.file = this.fileCache.getFile(this.digest);
            if (this.file == null) {
                try {
                    File tmp = this.fileCache.getTempFile();
                    if (this.fetchFile(tmp)) {
                        this.file = this.fileCache.putFile(this.digest, tmp);
                    } else {
                        tmp.delete();
                    }
                }
                catch (IOException e) {
                    log.error((Object)"Unable to retrieve file from SQL binary store", (Throwable)e);
                }
            }
            if (this.file != null) {
                this.length = this.file.length();
                this.hasLength = true;
            }
        }
        return this.file == null ? null : new FileSource(this.file);
    }

    protected abstract boolean fetchFile(File var1);

    @Override
    public long getLength() {
        if (!this.hasLength) {
            Long len = this.getLengthFromCache();
            if (len == null && (len = this.fetchLength()) != null) {
                this.putLengthInCache(len);
            }
            this.length = len == null ? 0L : len;
            this.hasLength = true;
        }
        return this.length;
    }

    protected abstract Long fetchLength();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Long getLengthFromCache() {
        File f = this.fileCache.getFile(this.digest + LEN_DIGEST_SUFFIX);
        if (f == null) {
            return null;
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(f);
            String len = IOUtils.toString((InputStream)in);
            Long l = Long.valueOf(len);
            return l;
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            Long l = null;
            return l;
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
        }
    }

    protected void putLengthInCache(Long len) {
        OutputStream out = null;
        try {
            File tmp = this.fileCache.getTempFile();
            out = new FileOutputStream(tmp);
            OutputStreamWriter writer = new OutputStreamWriter(out);
            writer.write(len.toString());
            ((Writer)writer).flush();
            out.close();
            out = null;
            this.fileCache.putFile(this.digest + LEN_DIGEST_SUFFIX, tmp);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
        }
    }
}

