/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.NXCore;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.model.NoSuchRepositoryException;
import org.nuxeo.ecm.core.repository.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.BinaryManager;
import org.nuxeo.ecm.core.storage.sql.Repository;
import org.nuxeo.ecm.core.storage.sql.RepositoryImpl;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLRepository;

public class RepositoryResolver {
    public static final Map<String, RepositoryImpl> repositories = new HashMap<String, RepositoryImpl>();

    private RepositoryResolver() {
    }

    public static void registerTestRepository(RepositoryImpl repo) {
        repositories.put(repo.getName(), repo);
    }

    public static List<Repository> getRepositories() {
        ArrayList<Repository> repositories = new ArrayList<Repository>();
        for (RepositoryDescriptor desc : NXCore.getRepositoryService().getRepositoryManager().getDescriptors()) {
            repositories.add(RepositoryResolver.getRepository(desc.getName()));
        }
        return repositories;
    }

    public static Repository getRepository(String repositoryName) {
        Object repo;
        block7: {
            repo = null;
            try {
                repo = NXCore.getRepository((String)repositoryName);
            }
            catch (NoSuchRepositoryException e) {
                try {
                    repo = NXCore.getRepositoryService().getRepositoryManager().getRepository(repositoryName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (repo == null) {
                    repo = repositories.get(repositoryName);
                }
                if (repo != null) break block7;
                throw new ClientRuntimeException("Cannot find repository " + repositoryName);
            }
        }
        if (repo instanceof Repository) {
            return (Repository)repo;
        }
        if (repo instanceof SQLRepository) {
            return ((SQLRepository)repo).repository;
        }
        throw new RuntimeException("Unknown repository class: " + repo.getClass().getName());
    }

    public static BinaryManager getBinaryManager(String repositoryName) {
        Repository repo = RepositoryResolver.getRepository(repositoryName);
        if (repo instanceof RepositoryImpl) {
            return ((RepositoryImpl)repo).getBinaryManager();
        }
        Class<?> repoClass = repo.getClass();
        if ("org.nuxeo.ecm.core.storage.sql.ra.ConnectionFactoryImpl".equals(repoClass.getCanonicalName())) {
            try {
                return RepositoryResolver.getBinaryManagerFromConnectionFactory(repo);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot get access to binary manager through the connection factory", e);
            }
        }
        throw new RuntimeException("Unknown repository class: " + repoClass);
    }

    protected static BinaryManager getBinaryManagerFromConnectionFactory(Repository repo) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = repo.getClass().getDeclaredField("managedConnectionFactory");
        field.setAccessible(true);
        Object factory = field.get(repo);
        field = factory.getClass().getDeclaredField("repository");
        field.setAccessible(true);
        return ((RepositoryImpl)field.get(factory)).getBinaryManager();
    }
}

