/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.Fragment;
import org.nuxeo.ecm.core.storage.sql.PersistenceContext;
import org.nuxeo.ecm.core.storage.sql.Row;

public final class SimpleFragment
extends Fragment {
    private static final long serialVersionUID = 1L;
    private static final Row UNKNOWN_ROW = new Row(null, (Serializable)null);
    public static final SimpleFragment UNKNOWN = new SimpleFragment(UNKNOWN_ROW, Fragment.State.DETACHED, null);

    public SimpleFragment(Row row, Fragment.State state, PersistenceContext context) {
        super(row, state, context);
    }

    @Override
    protected Fragment.State refetch() throws StorageException {
        Row newrow = this.context.mapper.readSimpleRow(this.row);
        if (newrow == null) {
            this.row.size = 0;
            return Fragment.State.ABSENT;
        }
        this.row = newrow;
        this.clearDirty();
        return Fragment.State.PRISTINE;
    }

    @Override
    protected Fragment.State refetchDeleted() throws StorageException {
        this.row.size = 0;
        return Fragment.State.ABSENT;
    }

    public Serializable get(String key) throws StorageException {
        this.accessed();
        return this.row.get(key);
    }

    public void put(String key, Serializable value) throws StorageException {
        this.accessed();
        this.row.put(key, value);
        if (this.oldvalues.length < this.row.values.length) {
            Serializable[] tmp = this.oldvalues;
            this.oldvalues = new Serializable[this.row.values.length];
            System.arraycopy(tmp, 0, this.oldvalues, 0, tmp.length);
        }
        this.markModified();
    }

    public String getString(String key) throws StorageException {
        return (String)((Object)this.get(key));
    }

    public List<String> getDirtyKeys() {
        LinkedList<String> keys = null;
        for (int i = 0; i < this.row.size; ++i) {
            if (SimpleFragment.same(this.oldvalues[i], this.row.values[i])) continue;
            if (keys == null) {
                keys = new LinkedList<String>();
            }
            keys.add(this.row.keys[i]);
        }
        return keys == null ? Collections.emptyList() : keys;
    }

    private static boolean same(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    public static class FieldComparator
    implements Comparator<SimpleFragment> {
        public final String key;

        public FieldComparator(String key) {
            this.key = key;
        }

        @Override
        public int compare(SimpleFragment frag1, SimpleFragment frag2) {
            return this.doCompare(frag1, frag2);
        }

        public <T> int doCompare(SimpleFragment frag1, SimpleFragment frag2) {
            try {
                Comparable value1 = (Comparable)((Object)frag1.get(this.key));
                Serializable value2 = frag2.get(this.key);
                if (value1 == null && value2 == null) {
                    return frag1.hashCode() - frag2.hashCode();
                }
                if (value1 == null) {
                    return 1;
                }
                if (value2 == null) {
                    return -1;
                }
                return value1.compareTo(value2);
            }
            catch (StorageException e) {
                return frag1.hashCode() - frag2.hashCode();
            }
        }
    }
}

