/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.coremodel;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.ListDiff;
import org.nuxeo.ecm.core.model.NoSuchPropertyException;
import org.nuxeo.ecm.core.model.Property;
import org.nuxeo.ecm.core.model.PropertyContainer;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.storage.sql.Node;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLBaseProperty;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLSession;

public class SQLComplexListProperty
extends SQLBaseProperty
implements PropertyContainer {
    protected final Node node;
    protected final String name;
    protected final SQLSession session;
    protected final ComplexType elementType;

    public SQLComplexListProperty(Node node, ListType type, String name, SQLSession session, boolean readonly) {
        super((Type)type, name, readonly);
        this.node = node;
        this.name = name;
        this.session = session;
        this.elementType = (ComplexType)type.getFieldType();
    }

    public String getName() {
        return this.name;
    }

    public List<Object> getValue() throws DocumentException {
        List<Property> properties = this.session.makeProperties(this.node, this.name, this.type, null, this.readonly, -1);
        ArrayList<Object> list = new ArrayList<Object>(properties.size());
        for (Property property : properties) {
            list.add(property.getValue());
        }
        return list;
    }

    public void setValue(Object value) throws DocumentException {
        this.checkWritable();
        if (value instanceof ListDiff) {
            this.setList((ListDiff)value);
        } else if (value instanceof List) {
            this.setList((List)value);
        } else {
            throw new IllegalArgumentException("Unsupported value object for a complex list: " + value.getClass().getName());
        }
    }

    @Override
    public Property getProperty(String posString) throws DocumentException {
        int pos;
        try {
            pos = Integer.parseInt(this.name);
        }
        catch (NumberFormatException e) {
            throw new NoSuchPropertyException(this.name + '/' + posString);
        }
        return this.session.makeProperty(this.node, this.name, this.type, this.readonly, pos);
    }

    public List<Property> getProperties() throws DocumentException {
        return this.session.makeProperties(this.node, this.name, this.type, null, this.readonly, -1);
    }

    @Override
    public Iterator<Property> getPropertyIterator() throws DocumentException {
        return this.getProperties().iterator();
    }

    @Override
    public boolean isPropertySet(String name) throws DocumentException {
        throw new UnsupportedOperationException();
    }

    public Map<String, Object> exportFlatMap(String[] schemas) throws DocumentException {
        throw new UnsupportedOperationException();
    }

    public Map<String, Map<String, Object>> exportMap(String[] schemas) throws DocumentException {
        throw new UnsupportedOperationException();
    }

    public Map<String, Object> exportMap(String schemaName) throws DocumentException {
        throw new UnsupportedOperationException();
    }

    public void importFlatMap(Map<String, Object> map) throws DocumentException {
        this.checkWritable();
        throw new UnsupportedOperationException();
    }

    public void importMap(Map<String, Map<String, Object>> map) throws DocumentException {
        this.checkWritable();
        throw new UnsupportedOperationException();
    }

    public List<String> getDirtyFields() {
        throw new UnsupportedOperationException();
    }

    public Object getPropertyValue(String name) throws DocumentException {
        return this.getProperty(name).getValue();
    }

    public String getString(String name) throws DocumentException {
        return (String)this.getProperty(name).getValue();
    }

    public boolean getBoolean(String name) throws DocumentException {
        Boolean value = (Boolean)this.getProperty(name).getValue();
        return value == null ? false : value;
    }

    public long getLong(String name) throws DocumentException {
        Long value = (Long)this.getProperty(name).getValue();
        return value == null ? 0L : value;
    }

    public double getDouble(String name) throws DocumentException {
        Double value = (Double)this.getProperty(name).getValue();
        return value == null ? 0.0 : value;
    }

    public Calendar getDate(String name) throws DocumentException {
        return (Calendar)this.getProperty(name).getValue();
    }

    public Blob getContent(String name) throws DocumentException {
        throw new UnsupportedOperationException();
    }

    public void setPropertyValue(String name, Object value) throws DocumentException {
        this.getProperty(name).setValue(value);
    }

    public void setString(String name, String value) throws DocumentException {
        this.setPropertyValue(name, value);
    }

    public void setBoolean(String name, boolean value) throws DocumentException {
        this.setPropertyValue(name, value);
    }

    public void setLong(String name, long value) throws DocumentException {
        this.setPropertyValue(name, value);
    }

    public void setDouble(String name, double value) throws DocumentException {
        this.setPropertyValue(name, value);
    }

    public void setDate(String name, Calendar value) throws DocumentException {
        this.setPropertyValue(name, value);
    }

    public void setContent(String name, Blob value) throws DocumentException {
        throw new UnsupportedOperationException();
    }

    public void removeProperty(String name) throws DocumentException {
        throw new UnsupportedOperationException();
    }

    public void setList(List<?> list) throws DocumentException {
        if (this.getValue().equals(list)) {
            return;
        }
        List<Node> nodes = this.session.getComplexList(this.node, this.name);
        for (Node n : nodes) {
            this.session.removeProperty(n);
        }
        List<Property> properties = this.session.makeProperties(this.node, this.name, this.type, null, this.readonly, list.size());
        int i = 0;
        for (Object value : list) {
            properties.get(i++).setValue(value);
        }
    }

    public void setList(ListDiff list) {
        if (!list.isDirty()) {
            return;
        }
        block7: for (ListDiff.Entry entry : list.diff()) {
            switch (entry.type) {
                case 1: {
                    continue block7;
                }
                case 3: {
                    continue block7;
                }
                case 2: {
                    continue block7;
                }
                case 5: {
                    continue block7;
                }
                case 4: {
                    continue block7;
                }
            }
        }
        throw new UnsupportedOperationException();
    }
}

