/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FullTextUtils;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.core.api.impl.FacetFilter;
import org.nuxeo.ecm.core.query.QueryFilter;
import org.nuxeo.ecm.core.query.sql.SQLQueryParser;
import org.nuxeo.ecm.core.query.sql.model.BooleanLiteral;
import org.nuxeo.ecm.core.query.sql.model.DateLiteral;
import org.nuxeo.ecm.core.query.sql.model.DefaultQueryVisitor;
import org.nuxeo.ecm.core.query.sql.model.DoubleLiteral;
import org.nuxeo.ecm.core.query.sql.model.Expression;
import org.nuxeo.ecm.core.query.sql.model.FromClause;
import org.nuxeo.ecm.core.query.sql.model.FromList;
import org.nuxeo.ecm.core.query.sql.model.Function;
import org.nuxeo.ecm.core.query.sql.model.IVisitor;
import org.nuxeo.ecm.core.query.sql.model.IntegerLiteral;
import org.nuxeo.ecm.core.query.sql.model.Literal;
import org.nuxeo.ecm.core.query.sql.model.LiteralList;
import org.nuxeo.ecm.core.query.sql.model.MultiExpression;
import org.nuxeo.ecm.core.query.sql.model.Operand;
import org.nuxeo.ecm.core.query.sql.model.Operator;
import org.nuxeo.ecm.core.query.sql.model.OrderByClause;
import org.nuxeo.ecm.core.query.sql.model.OrderByExpr;
import org.nuxeo.ecm.core.query.sql.model.OrderByList;
import org.nuxeo.ecm.core.query.sql.model.Reference;
import org.nuxeo.ecm.core.query.sql.model.SQLQuery;
import org.nuxeo.ecm.core.query.sql.model.SelectClause;
import org.nuxeo.ecm.core.query.sql.model.StringLiteral;
import org.nuxeo.ecm.core.query.sql.model.WhereClause;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.ColumnType;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.ModelProperty;
import org.nuxeo.ecm.core.storage.sql.PropertyType;
import org.nuxeo.ecm.core.storage.sql.Session;
import org.nuxeo.ecm.core.storage.sql.jdbc.QueryMaker;
import org.nuxeo.ecm.core.storage.sql.jdbc.SQLInfo;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Database;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Join;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Select;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Table;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.TableAlias;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;

public class NXQLQueryMaker
implements QueryMaker {
    private static final Log log = LogFactory.getLog(NXQLQueryMaker.class);
    public static final String TYPE_DOCUMENT = "Document";
    public static final String TYPE_RELATION = "Relation";
    protected static final String TABLE_HIER_ALIAS = "_H";
    protected static final String TABLE_FRAG_ALIAS = "_F";
    protected static final String COL_ALIAS_PREFIX = "_C";
    protected static final String UNION_ALIAS = "_T";
    protected static final String WITH_ALIAS_PREFIX = "_W";
    protected static final String READ_ACL_ALIAS = "_RACL";
    protected static final String DATE_CAST = "DATE";
    protected static final Set<String> MIXINS_NOT_PER_INSTANCE = new HashSet<String>(Arrays.asList("Folderish", "HiddenInNavigation"));
    protected SQLInfo sqlInfo;
    protected Database database;
    protected Dialect dialect;
    protected Model model;
    protected Session.PathResolver pathResolver;
    protected boolean onlyRelations;
    protected final List<String> whatColumnNames = new LinkedList<String>();
    protected final List<String> orderByColumnNames = new LinkedList<String>();
    protected final Map<String, String> aliasesByName = new HashMap<String, String>();
    protected final List<String> aliases = new LinkedList<String>();
    protected boolean hasWildcardIndex;
    protected boolean orderByHasWildcardIndex;
    protected Boolean proxyClause;
    protected Table hierTable;
    protected Table dataHierTable;
    protected List<Join> joins;
    protected List<String> whereClauses;
    protected List<Serializable> whereParams;
    protected Map<String, Table> propertyFragmentTables = new HashMap<String, Table>();
    protected int fragJoinCount = 0;
    protected static final Pattern INDEX = Pattern.compile("\\d+|\\*|\\*\\d+");
    protected static final Pattern HAS_WILDCARD_INDEX = Pattern.compile(".*/(\\*|\\*\\d+)(/.*|$)");
    protected static final Pattern INDEX_SLASH = Pattern.compile("/(?:\\d+|\\*|\\*\\d+)(/|$)");
    protected static final Pattern NON_CANON_INDEX = Pattern.compile("[^/\\[\\]]+\\[(\\d+|\\*|\\*\\d+)\\]");

    @Override
    public String getName() {
        return "NXQL";
    }

    @Override
    public boolean accepts(String queryType) {
        return queryType.equals("NXQL");
    }

    @Override
    public QueryMaker.Query buildQuery(SQLInfo sqlInfo, Model model, Session.PathResolver pathResolver, String query, QueryFilter queryFilter, Object ... params) throws StorageException {
        this.sqlInfo = sqlInfo;
        this.database = sqlInfo.database;
        this.dialect = sqlInfo.dialect;
        this.model = model;
        this.pathResolver = pathResolver;
        SQLQuery sqlQuery = SQLQueryParser.parse((String)query);
        for (SQLQuery.Transformer transformer : queryFilter.getQueryTransformers()) {
            sqlQuery = transformer.transform(queryFilter.getPrincipal(), sqlQuery);
        }
        boolean selectStar = sqlQuery.select.isEmpty();
        if (selectStar) {
            sqlQuery.select.add((Operand)new Reference("ecm:uuid"));
        }
        QueryAnalyzer queryAnalyzer = this.newQueryAnalyzer(queryFilter.getFacetFilter());
        try {
            queryAnalyzer.visitQuery(sqlQuery);
        }
        catch (QueryMaker.QueryCannotMatchException e) {
            return null;
        }
        catch (QueryMaker.QueryMakerException e) {
            throw new StorageException(e.getMessage(), e);
        }
        if (this.onlyRelations) {
            if (this.proxyClause == Boolean.TRUE) {
                return null;
            }
            this.proxyClause = Boolean.FALSE;
        }
        DocKind[] docKinds = this.proxyClause == Boolean.TRUE ? new DocKind[]{DocKind.PROXY} : (this.proxyClause == Boolean.FALSE ? new DocKind[]{DocKind.DIRECT} : new DocKind[]{DocKind.DIRECT, DocKind.PROXY});
        boolean doUnion = docKinds.length > 1;
        HashSet<String> onlyOrderByColumnNames = new HashSet<String>(this.orderByColumnNames);
        onlyOrderByColumnNames.removeAll(this.whatColumnNames);
        boolean distinct = sqlQuery.select.isDistinct();
        if (selectStar && this.hasWildcardIndex) {
            distinct = true;
        }
        if (doUnion || distinct) {
            if (distinct && !onlyOrderByColumnNames.isEmpty()) {
                if (!selectStar) {
                    throw new StorageException("For SELECT DISTINCT the ORDER BY columns must be in the SELECT list, missing: " + onlyOrderByColumnNames);
                }
                if (this.orderByHasWildcardIndex) {
                    throw new StorageException("For SELECT * the ORDER BY columns cannot use wildcard indexes");
                }
            }
            for (String name : onlyOrderByColumnNames) {
                sqlQuery.select.add((Operand)new Reference(name));
            }
        }
        List<Column> whatColumns = null;
        List<String> whatKeys = null;
        Select select = null;
        String orderBy = null;
        ArrayList<String> statements = new ArrayList<String>(2);
        LinkedList<Serializable> selectParams = new LinkedList<Serializable>();
        LinkedList<String> withTables = new LinkedList<String>();
        LinkedList<Select> withSelects = new LinkedList<Select>();
        LinkedList<String> withSelectsStatements = new LinkedList<String>();
        LinkedList withParams = new LinkedList();
        Table hier = this.database.getTable("hierarchy");
        for (DocKind docKind : docKinds) {
            WhereBuilder whereBuilder;
            String from;
            String hierId;
            this.joins = new LinkedList<Join>();
            this.whereClauses = new LinkedList<String>();
            this.whereParams = new LinkedList<Serializable>();
            this.propertyFragmentTables = new HashMap<String, Table>();
            this.fragJoinCount = 0;
            switch (docKind) {
                case DIRECT: {
                    this.dataHierTable = this.hierTable = hier;
                    hierId = this.hierTable.getColumn("id").getFullQuotedName();
                    from = this.hierTable.getQuotedName();
                    break;
                }
                case PROXY: {
                    this.hierTable = new TableAlias(hier, TABLE_HIER_ALIAS);
                    this.dataHierTable = hier;
                    from = hier.getQuotedName() + " " + this.hierTable.getQuotedName();
                    hierId = this.hierTable.getColumn("id").getFullQuotedName();
                    Table proxies = this.database.getTable("proxies");
                    this.addJoin(1, null, proxies, "id", this.hierTable, "id", null, -1);
                    this.addJoin(1, null, this.dataHierTable, "id", proxies, "targetid", null, -1);
                    break;
                }
                default: {
                    throw new AssertionError((Object)docKind);
                }
            }
            this.fixInitialJoins();
            try {
                whereBuilder = this.newWhereBuilder(docKind == DocKind.PROXY);
            }
            catch (QueryMaker.QueryMakerException e) {
                throw new StorageException(e.getMessage(), e);
            }
            sqlQuery.select.accept((IVisitor)whereBuilder);
            whatColumns = whereBuilder.whatColumns;
            whatKeys = whereBuilder.whatKeys;
            ArrayList<String> whatNames = new ArrayList<String>(1);
            ArrayList<String> whatNamesParams = new ArrayList<String>(1);
            String mainAlias = hierId;
            this.aliasesByName.clear();
            this.aliases.clear();
            for (int i = 0; i < whatColumns.size(); ++i) {
                Column col = whatColumns.get(i);
                String key = whatKeys.get(i);
                String alias = this.dialect.openQuote() + COL_ALIAS_PREFIX + (i + 1) + this.dialect.closeQuote();
                this.aliasesByName.put(key, alias);
                this.aliases.add(alias);
                String whatName = this.getSelectColName(col);
                whatName = whatName + " AS " + alias;
                if (col.getTable().getRealTable() == hier) {
                    if (col.getKey().equals("id")) {
                        mainAlias = alias;
                    }
                }
                whatNames.add(whatName);
            }
            this.fixWhatColumns(whatColumns);
            if (queryAnalyzer.wherePredicate != null) {
                queryAnalyzer.wherePredicate.accept((IVisitor)whereBuilder);
                String where = whereBuilder.buf.toString();
                if (where.length() != 0) {
                    this.whereClauses.add(where);
                }
            }
            boolean orderByScoreDesc = sqlQuery.orderBy == null && whereBuilder.ftJoinNumber == 1 && !distinct;
            Dialect.FulltextMatchInfo ftMatchInfo = whereBuilder.ftMatchInfo;
            if (orderBy == null) {
                if (sqlQuery.orderBy != null) {
                    whereBuilder.aliasOrderByColumns = doUnion;
                    whereBuilder.buf.setLength(0);
                    sqlQuery.orderBy.accept((IVisitor)whereBuilder);
                    orderBy = whereBuilder.buf.toString();
                } else if (orderByScoreDesc) {
                    orderBy = ftMatchInfo.scoreAlias + " DESC";
                }
            }
            if (orderByScoreDesc) {
                String scoreExprSql = ftMatchInfo.scoreExpr + " AS " + ftMatchInfo.scoreAlias;
                whatNames.add(scoreExprSql);
                if (ftMatchInfo.scoreExprParam != null) {
                    whatNamesParams.add(ftMatchInfo.scoreExprParam);
                }
            }
            String selectWhat = StringUtils.join(whatNames, (String)", ");
            if (!doUnion && distinct) {
                selectWhat = "DISTINCT " + selectWhat;
            }
            String securityClause = null;
            LinkedList<Object[]> securityParams = new LinkedList<Object[]>();
            Join securityJoin = null;
            if (queryFilter.getPrincipals() != null) {
                String id;
                Object principals = queryFilter.getPrincipals();
                Object permissions = queryFilter.getPermissions();
                if (!this.dialect.supportsArrays()) {
                    principals = StringUtils.join((Object[])principals, (String)"|");
                    permissions = StringUtils.join((Object[])permissions, (String)"|");
                }
                String string = id = this.dialect.supportsWith() ? mainAlias : hierId;
                if (this.dialect.supportsReadAcl()) {
                    String racl = this.dialect.openQuote() + READ_ACL_ALIAS + this.dialect.closeQuote();
                    securityClause = this.dialect.getReadAclsCheckSql(racl + ".acl_id");
                    securityParams.add((Object[])principals);
                    securityJoin = new Join(1, "hierarchy_read_acl", READ_ACL_ALIAS, null, id, racl + ".id");
                } else {
                    securityClause = this.dialect.getSecurityCheckSql(id);
                    securityParams.add((Object[])principals);
                    securityParams.add((Object[])permissions);
                }
            }
            if (securityClause != null) {
                if (this.dialect.supportsWith()) {
                    String withTable = this.dialect.openQuote() + WITH_ALIAS_PREFIX + (statements.size() + 1) + this.dialect.closeQuote();
                    withTables.add(withTable);
                    Select withSelect = new Select(null);
                    withSelect.setWhat("*");
                    withSelect.setFrom(withTable + (securityJoin == null ? "" : " " + securityJoin.toSql(this.dialect)));
                    withSelect.setWhere(securityClause);
                    withSelects.add(withSelect);
                    withSelectsStatements.add(withSelect.getStatement());
                    withParams.addAll(securityParams);
                } else {
                    if (securityJoin != null) {
                        this.joins.add(securityJoin);
                    }
                    this.whereClauses.add(securityClause);
                    this.whereParams.addAll(securityParams);
                }
            }
            select = new Select(null);
            select.setWhat(selectWhat);
            selectParams.addAll(whatNamesParams);
            StringBuilder fromb = new StringBuilder(from);
            if (this.dialect.needsOracleJoins() && doUnion && securityJoin != null && ftMatchInfo != null) {
                for (Join join : this.joins) {
                    if (join.whereClauses.isEmpty()) continue;
                    throw new StorageException("Query too complex for Oracle (NXP-5410)");
                }
                LinkedList<String> joinClauses = new LinkedList<String>();
                for (Join join : this.joins) {
                    fromb.append(", ");
                    fromb.append(join.getTable(this.dialect));
                    if (join.tableParam != null) {
                        selectParams.add((Serializable)((Object)join.tableParam));
                    }
                    String joinClause = join.getClause();
                    if (join.kind == 2) {
                        joinClause = joinClause + "(+)";
                    }
                    if (!join.whereClauses.isEmpty()) {
                        joinClause = joinClause + " AND " + StringUtils.join(join.whereClauses, (String)" AND ");
                        selectParams.addAll(join.whereParams);
                    }
                    joinClauses.add(joinClause);
                }
                this.whereClauses.addAll(0, joinClauses);
            } else {
                Collections.sort(this.joins);
                for (Join join : this.joins) {
                    if (join.tableParam != null) {
                        selectParams.add((Serializable)((Object)join.tableParam));
                    }
                    String joinClause = join.toSql(this.dialect);
                    if (!join.whereClauses.isEmpty()) {
                        joinClause = joinClause + " AND " + StringUtils.join(join.whereClauses, (String)" AND ");
                        selectParams.addAll(join.whereParams);
                    }
                    fromb.append(joinClause);
                }
            }
            select.setFrom(fromb.toString());
            select.setWhere(StringUtils.join(this.whereClauses, (String)" AND "));
            selectParams.addAll(this.whereParams);
            statements.add(select.getStatement());
        }
        if (doUnion) {
            String subselect;
            select = new Select(null);
            String selectWhat = StringUtils.join(this.aliases, (String)", ");
            if (distinct) {
                selectWhat = "DISTINCT " + selectWhat;
            }
            select.setWhat(selectWhat);
            if (withSelects.isEmpty()) {
                subselect = StringUtils.join(statements, (String)" UNION ALL ");
            } else {
                StringBuilder with = new StringBuilder("WITH ");
                for (int i = 0; i < statements.size(); ++i) {
                    if (i > 0) {
                        with.append(", ");
                    }
                    with.append((String)withTables.get(i));
                    with.append(" AS (");
                    with.append((String)statements.get(i));
                    with.append(')');
                }
                with.append(' ');
                subselect = with.toString() + StringUtils.join(withSelectsStatements, (String)" UNION ALL ");
                selectParams.addAll(withParams);
            }
            String selectFrom = '(' + subselect + ')';
            if (this.dialect.needsAliasForDerivedTable()) {
                selectFrom = selectFrom + " AS " + this.dialect.openQuote() + UNION_ALIAS + this.dialect.closeQuote();
            }
            select.setFrom(selectFrom);
        } else if (!withSelects.isEmpty()) {
            select = new Select(null);
            String with = (String)withTables.get(0) + " AS (" + (String)statements.get(0) + ')';
            select.setWith(with);
            Select withSelect = (Select)withSelects.get(0);
            select.setWhat(withSelect.getWhat());
            select.setFrom(withSelect.getFrom());
            select.setWhere(withSelect.getWhere());
            selectParams.addAll(withParams);
        }
        select.setOrderBy(orderBy);
        this.fixSelect(select);
        QueryMaker.Query q = new QueryMaker.Query();
        SQLInfo.ColumnMapMaker mapMaker = new SQLInfo.ColumnMapMaker(whatColumns, whatKeys);
        q.selectInfo = new SQLInfo.SQLInfoSelect(select.getStatement(), whatColumns, mapMaker, null, null);
        q.selectParams = selectParams;
        return q;
    }

    protected void addJoin(int kind, String alias, Table table, String column, Table contextTable, String contextColumn, String name, int index) {
        String on1 = contextTable.getColumn(contextColumn).getFullQuotedName();
        String on2 = table.getColumn(column).getFullQuotedName();
        Join join = new Join(kind, table.getRealTable().getQuotedName(), alias, null, on1, on2);
        if (name != null) {
            String nameCol = table.getColumn("name").getFullQuotedName();
            join.addWhereClause(nameCol + " = ?", (Serializable)((Object)name));
        }
        if (index != -1) {
            String posCol = table.getColumn("pos").getFullQuotedName();
            join.addWhereClause(posCol + " = ?", Long.valueOf(index));
        }
        this.joins.add(join);
    }

    protected Table getFragmentTable(Table contextHier, String contextKey, String fragmentName, int index, boolean skipJoin) {
        Table table = this.propertyFragmentTables.get(contextKey);
        if (table == null) {
            Table baseTable = this.database.getTable(fragmentName);
            String alias = TABLE_FRAG_ALIAS + ++this.fragJoinCount;
            table = new TableAlias(baseTable, alias);
            this.propertyFragmentTables.put(contextKey, table);
            if (!skipJoin) {
                this.addJoin(2, alias, table, "id", contextHier, "id", null, index);
            }
        }
        return table;
    }

    protected void fixInitialJoins() {
    }

    protected String getSelectColName(Column col) {
        return col.getFullQuotedName();
    }

    protected void fixWhatColumns(List<Column> whatColumns) {
    }

    protected void fixSelect(Select select) {
    }

    protected static boolean findFulltextIndexOrField(Model model, String[] nameref) {
        boolean useIndex;
        String name = nameref[0];
        if (name.equals("ecm:fulltext")) {
            name = "default";
            useIndex = true;
        } else {
            char sep = name.charAt("ecm:fulltext".length());
            if (sep != '.' && sep != '_') {
                throw new QueryMaker.QueryMakerException("Unknown field: " + name);
            }
            useIndex = sep == '_';
            name = name.substring("ecm:fulltext".length() + 1);
            if (useIndex) {
                if (!model.fulltextInfo.indexNames.contains(name)) {
                    throw new QueryMaker.QueryMakerException("No such fulltext index: " + name);
                }
            } else {
                String index = model.fulltextInfo.fieldToIndexName.get(name);
                if (index != null) {
                    name = index;
                    useIndex = true;
                }
            }
        }
        nameref[0] = name;
        return useIndex;
    }

    public static String canonicalXPath(String xpath) {
        while (xpath.length() > 0 && xpath.charAt(0) == '/') {
            xpath = xpath.substring(1);
        }
        if (xpath.indexOf(91) == -1) {
            return xpath;
        }
        return NON_CANON_INDEX.matcher(xpath).replaceAll("$1");
    }

    public static String simpleXPath(String xpath) {
        xpath = NXQLQueryMaker.canonicalXPath(xpath);
        return INDEX_SLASH.matcher(xpath).replaceAll("/*$1");
    }

    public boolean hasWildcardIndex(String xpath) {
        xpath = NXQLQueryMaker.canonicalXPath(xpath);
        return HAS_WILDCARD_INDEX.matcher(xpath).matches();
    }

    protected QueryAnalyzer newQueryAnalyzer(FacetFilter facetFilter) {
        return new QueryAnalyzer(facetFilter);
    }

    protected WhereBuilder newWhereBuilder(boolean isProxies) {
        return new WhereBuilder(isProxies);
    }

    protected class WhereBuilder
    extends DefaultQueryVisitor {
        private static final long serialVersionUID = 1L;
        public static final String PATH_SEP = "/";
        public final List<Column> whatColumns = new LinkedList<Column>();
        public final List<String> whatKeys = new LinkedList<String>();
        public final StringBuilder buf = new StringBuilder();
        protected int uniquePropIndex = 0;
        protected int hierJoinCount = 0;
        protected Map<String, Table> propertyHierTables = new HashMap<String, Table>();
        protected final boolean isProxies;
        protected boolean aliasOrderByColumns;
        protected boolean allowSubSelect;
        protected boolean inSelect;
        protected boolean inOrderBy;
        protected int ftJoinNumber;
        protected Dialect.FulltextMatchInfo ftMatchInfo;

        public WhereBuilder(boolean isProxies) {
            this.isProxies = isProxies;
        }

        public Column findColumn(String name, boolean allowSubSelect, boolean inOrderBy) {
            Column column;
            if (name.startsWith("ecm:")) {
                column = this.getSpecialColumn(name);
            } else {
                ColumnInfo info = this.getColumnInfo(name);
                if (info.needsSubSelect && !allowSubSelect) {
                    String msg = inOrderBy ? "Cannot use collection %s in ORDER BY clause" : "Can only use collection %s with =, <>, IN or NOT IN clause";
                    throw new QueryMaker.QueryMakerException(String.format(msg, name));
                }
                column = info.column;
            }
            return column;
        }

        protected Column getSpecialColumn(String name) {
            String fragmentKey;
            Table table = null;
            String fragmentName = null;
            if ("ecm:uuid".equals(name)) {
                table = NXQLQueryMaker.this.hierTable;
                Model cfr_ignored_0 = NXQLQueryMaker.this.model;
                fragmentKey = "id";
            } else if ("ecm:name".equals(name)) {
                table = NXQLQueryMaker.this.hierTable;
                Model cfr_ignored_1 = NXQLQueryMaker.this.model;
                fragmentKey = "name";
            } else if ("ecm:pos".equals(name)) {
                table = NXQLQueryMaker.this.hierTable;
                Model cfr_ignored_2 = NXQLQueryMaker.this.model;
                fragmentKey = "pos";
            } else if ("ecm:parentId".equals(name)) {
                table = NXQLQueryMaker.this.hierTable;
                Model cfr_ignored_3 = NXQLQueryMaker.this.model;
                fragmentKey = "parentid";
            } else if ("ecm:isCheckedInVersion".equals(name)) {
                table = NXQLQueryMaker.this.hierTable;
                Model cfr_ignored_4 = NXQLQueryMaker.this.model;
                fragmentKey = "isversion";
            } else if ("ecm:primaryType".equals(name)) {
                table = NXQLQueryMaker.this.dataHierTable;
                Model cfr_ignored_5 = NXQLQueryMaker.this.model;
                fragmentKey = "primarytype";
            } else {
                if ("ecm:mixinType".equals(name)) {
                    throw new QueryMaker.QueryMakerException("Cannot use non-toplevel " + name + " in query");
                }
                if ("ecm:currentLifeCycleState".equals(name)) {
                    Model cfr_ignored_6 = NXQLQueryMaker.this.model;
                    fragmentName = "misc";
                    Model cfr_ignored_7 = NXQLQueryMaker.this.model;
                    fragmentKey = "lifecyclestate";
                } else if ("ecm:versionLabel".equals(name)) {
                    Model cfr_ignored_8 = NXQLQueryMaker.this.model;
                    fragmentName = "versions";
                    Model cfr_ignored_9 = NXQLQueryMaker.this.model;
                    fragmentKey = "label";
                } else if ("ecm:lock".equals(name) || "ecm:lockOwner".equals(name)) {
                    Model cfr_ignored_10 = NXQLQueryMaker.this.model;
                    fragmentName = "locks";
                    Model cfr_ignored_11 = NXQLQueryMaker.this.model;
                    fragmentKey = "owner";
                } else if ("ecm:lockCreated".equals(name)) {
                    Model cfr_ignored_12 = NXQLQueryMaker.this.model;
                    fragmentName = "locks";
                    Model cfr_ignored_13 = NXQLQueryMaker.this.model;
                    fragmentKey = "created";
                } else if ("ecm:fulltextJobId".equals(name)) {
                    Model cfr_ignored_14 = NXQLQueryMaker.this.model;
                    fragmentName = "fulltext";
                    Model cfr_ignored_15 = NXQLQueryMaker.this.model;
                    fragmentKey = "jobid";
                } else {
                    if (name.startsWith("ecm:fulltext")) {
                        throw new QueryMaker.QueryMakerException("ecm:fulltext must be used as left-hand operand");
                    }
                    throw new QueryMaker.QueryMakerException("No such property: " + name);
                }
            }
            if (table == null) {
                table = NXQLQueryMaker.this.getFragmentTable(NXQLQueryMaker.this.dataHierTable, fragmentName, fragmentName, -1, false);
            }
            return table.getColumn(fragmentKey);
        }

        protected ColumnInfo getColumnInfo(String xpath) {
            Table hier;
            Table contextHier = hier = NXQLQueryMaker.this.dataHierTable;
            xpath = NXQLQueryMaker.canonicalXPath(xpath);
            String[] segments = xpath.split(PATH_SEP);
            String simple = null;
            String contextKey = null;
            String segment = null;
            ModelProperty prop = null;
            for (int i = 0; i < segments.length; ++i) {
                Table table;
                String next;
                segment = segments[i];
                simple = simple == null ? segment : simple + '/' + segment;
                String contextStart = contextKey == null ? "" : contextKey + '/';
                String contextSuffix = "";
                int index = -1;
                boolean star = false;
                boolean isArrayElement = false;
                if (i < segments.length - 1 && INDEX.matcher(next = segments[i + 1]).matches()) {
                    isArrayElement = true;
                    if (next.startsWith("*")) {
                        star = true;
                        next = next.substring(1);
                    }
                    if (!next.isEmpty()) {
                        index = Integer.parseInt(next);
                    }
                    ++i;
                    simple = simple + "/*";
                    if (star) {
                        contextSuffix = index == -1 ? "/*-" + ++this.uniquePropIndex : "/*" + index;
                        index = -1;
                    } else {
                        contextSuffix = PATH_SEP + index;
                    }
                }
                if ((prop = NXQLQueryMaker.this.model.getPathPropertyInfo(simple)) == null) {
                    throw new QueryMaker.QueryMakerException("No such property: " + xpath);
                }
                if (i < segments.length - 1) {
                    if (prop != ModelProperty.NONE) {
                        throw new QueryMaker.QueryMakerException("No such property: " + xpath);
                    }
                    contextKey = contextStart + segment + contextSuffix;
                    table = this.propertyHierTables.get(contextKey);
                    if (table == null) {
                        String alias = NXQLQueryMaker.TABLE_HIER_ALIAS + ++this.hierJoinCount;
                        table = new TableAlias(hier, alias);
                        this.propertyHierTables.put(contextKey, table);
                        Model cfr_ignored_0 = NXQLQueryMaker.this.model;
                        Model cfr_ignored_1 = NXQLQueryMaker.this.model;
                        NXQLQueryMaker.this.addJoin(2, alias, table, "parentid", contextHier, "id", segment, index);
                    }
                } else {
                    if (prop == ModelProperty.NONE) {
                        throw new QueryMaker.QueryMakerException("No such property: " + xpath);
                    }
                    contextKey = contextStart + prop.fragmentName + contextSuffix;
                    boolean skipJoin = !isArrayElement && prop.propertyType.isArray();
                    Table table2 = NXQLQueryMaker.this.getFragmentTable(contextHier, contextKey, prop.fragmentName, index, skipJoin);
                    return new ColumnInfo(table2.getColumn(prop.fragmentKey), isArrayElement, prop.propertyType);
                }
                contextHier = table;
            }
            throw new AssertionError((Object)"not reached");
        }

        protected Set<String> getStringLiterals(LiteralList list) throws QueryMaker.QueryMakerException {
            HashSet<String> set = new HashSet<String>();
            for (Literal literal : list) {
                if (!(literal instanceof StringLiteral)) {
                    throw new QueryMaker.QueryMakerException("requires string literals");
                }
                set.add(((StringLiteral)literal).value);
            }
            return set;
        }

        public void visitQuery(SQLQuery node) {
            super.visitQuery(node);
        }

        public void visitSelectClause(SelectClause node) {
            this.inSelect = true;
            super.visitSelectClause(node);
            this.inSelect = false;
        }

        public void visitMultiExpression(MultiExpression node) {
            this.buf.append('(');
            Iterator it = node.values.iterator();
            while (it.hasNext()) {
                ((Operand)it.next()).accept((IVisitor)this);
                if (!it.hasNext()) continue;
                node.operator.accept((IVisitor)this);
            }
            this.buf.append(')');
        }

        public void visitExpression(Expression node) {
            Operator op;
            this.buf.append('(');
            Reference ref = node.lvalue instanceof Reference ? (Reference)node.lvalue : null;
            String name = ref != null ? ref.name : null;
            String cast = ref != null ? ref.cast : null;
            Operand rvalue = node.rvalue;
            if (NXQLQueryMaker.DATE_CAST.equals(cast)) {
                this.checkDateLiteralForCast(rvalue, node);
            }
            if ((op = node.operator) == Operator.STARTSWITH) {
                this.visitExpressionStartsWith(node);
            } else if ("ecm:path".equals(name)) {
                this.visitExpressionEcmPath(node);
            } else if ("ecm:isProxy".equals(name)) {
                this.visitExpressionIsProxy(node);
            } else if ("ecm:isCheckedInVersion".equals(name)) {
                this.visitExpressionIsVersion(node);
            } else if ("ecm:mixinType".equals(name)) {
                this.visitExpressionMixinType(node);
            } else if (name != null && name.startsWith("ecm:fulltext") && !"ecm:fulltextJobId".equals(name)) {
                this.visitExpressionFulltext(node, name);
            } else if (!(op != Operator.EQ && op != Operator.NOTEQ && op != Operator.IN && op != Operator.NOTIN && op != Operator.LIKE && op != Operator.NOTLIKE && op != Operator.ILIKE && op != Operator.NOTILIKE || name == null || name.startsWith("ecm:"))) {
                ColumnInfo info = this.getColumnInfo(name);
                if (info.needsSubSelect) {
                    Operator directOp;
                    boolean direct;
                    boolean bl = direct = op == Operator.EQ || op == Operator.IN || op == Operator.LIKE || op == Operator.ILIKE;
                    Operator operator = direct ? op : (op == Operator.NOTEQ ? Operator.EQ : (op == Operator.NOTIN ? Operator.IN : (directOp = op == Operator.NOTLIKE ? Operator.LIKE : Operator.ILIKE)));
                    if (!direct) {
                        this.buf.append("NOT ");
                    }
                    this.generateExistsStart(this.buf, info.column.getTable());
                    this.allowSubSelect = true;
                    if (directOp == Operator.ILIKE) {
                        this.visitExpressionIlike(info.column, directOp, rvalue);
                    } else {
                        this.visitReference(info.column, cast);
                        directOp.accept((IVisitor)this);
                        rvalue.accept((IVisitor)this);
                    }
                    this.allowSubSelect = false;
                    this.generateExistsEnd(this.buf);
                } else {
                    if (info.isBoolean) {
                        if (!(rvalue instanceof IntegerLiteral)) {
                            throw new QueryMaker.QueryMakerException("Boolean expressions require literal 0 or 1 as right argument");
                        }
                        long v = ((IntegerLiteral)rvalue).value;
                        if (v != 0L && v != 1L) {
                            throw new QueryMaker.QueryMakerException("Boolean expressions require literal 0 or 1 as right argument");
                        }
                        rvalue = new BooleanLiteral(v == 1L);
                    }
                    if (op == Operator.ILIKE || op == Operator.NOTILIKE) {
                        this.visitExpressionIlike(info.column, op, rvalue);
                    } else {
                        this.visitReference(info.column, cast);
                        op.accept((IVisitor)this);
                        rvalue.accept((IVisitor)this);
                    }
                }
            } else if (node.operator == Operator.BETWEEN || node.operator == Operator.NOTBETWEEN) {
                LiteralList l = (LiteralList)rvalue;
                if (NXQLQueryMaker.DATE_CAST.equals(cast)) {
                    this.checkDateLiteralForCast((Operand)l.get(0), node);
                    this.checkDateLiteralForCast((Operand)l.get(1), node);
                }
                node.lvalue.accept((IVisitor)this);
                this.buf.append(' ');
                node.operator.accept((IVisitor)this);
                this.buf.append(' ');
                ((Literal)l.get(0)).accept((IVisitor)this);
                this.buf.append(" AND ");
                ((Literal)l.get(1)).accept((IVisitor)this);
            } else {
                super.visitExpression(node);
            }
            this.buf.append(')');
        }

        protected void checkDateLiteralForCast(Operand value, Expression node) {
            if (value instanceof DateLiteral && !((DateLiteral)value).onlyDate) {
                throw new QueryMaker.QueryMakerException("DATE() cast must be used with DATE literal, not TIMESTAMP: " + node);
            }
        }

        protected void generateExistsStart(StringBuilder buf, Table table) {
            String tableName = table.isAlias() ? table.getRealTable().getQuotedName() + " " + table.getQuotedName() : table.getQuotedName();
            Object[] objectArray = new Object[3];
            objectArray[0] = tableName;
            Model cfr_ignored_0 = NXQLQueryMaker.this.model;
            objectArray[1] = NXQLQueryMaker.this.dataHierTable.getColumn("id").getFullQuotedName();
            Model cfr_ignored_1 = NXQLQueryMaker.this.model;
            objectArray[2] = table.getColumn("id").getFullQuotedName();
            buf.append(String.format("EXISTS (SELECT 1 FROM %s WHERE %s = %s AND ", objectArray));
        }

        protected void generateExistsEnd(StringBuilder buf) {
            buf.append(")");
        }

        protected void visitExpressionStartsWith(Expression node) {
            String name;
            if (!(node.lvalue instanceof Reference)) {
                throw new QueryMaker.QueryMakerException("Illegal left argument for " + Operator.STARTSWITH + ": " + node.lvalue);
            }
            if (!(node.rvalue instanceof StringLiteral)) {
                throw new QueryMaker.QueryMakerException(Operator.STARTSWITH + " requires literal path as right argument");
            }
            String path = ((StringLiteral)node.rvalue).value;
            if (path.length() > 1 && path.endsWith(PATH_SEP)) {
                path = path.substring(0, path.length() - PATH_SEP.length());
            }
            if ("ecm:path".equals(name = ((Reference)node.lvalue).name)) {
                this.visitExpressionStartsWithPath(path);
            } else {
                this.visitExpressionStartsWithNonPath(node, path);
            }
        }

        protected void visitExpressionStartsWithPath(String path) {
            Serializable id;
            try {
                id = NXQLQueryMaker.this.pathResolver.getIdForPath(path);
            }
            catch (StorageException e) {
                throw new QueryMaker.QueryMakerException((Throwable)((Object)e));
            }
            if (id == null) {
                this.buf.append("0=1");
            } else {
                Model cfr_ignored_0 = NXQLQueryMaker.this.model;
                this.buf.append(NXQLQueryMaker.this.dialect.getInTreeSql(NXQLQueryMaker.this.hierTable.getColumn("id").getFullQuotedName()));
                NXQLQueryMaker.this.whereParams.add(id);
            }
        }

        protected void visitExpressionStartsWithNonPath(Expression node, String path) {
            String name = ((Reference)node.lvalue).name;
            ColumnInfo info = this.getColumnInfo(name);
            if (info.needsSubSelect) {
                this.generateExistsStart(this.buf, info.column.getTable());
            }
            this.buf.append('(');
            this.visitReference(info.column);
            this.buf.append(" = ");
            this.visitStringLiteral(path);
            this.buf.append(" OR ");
            this.visitReference(info.column);
            this.buf.append(" LIKE ");
            this.visitStringLiteral(path + PATH_SEP + '%');
            this.buf.append(')');
            if (info.needsSubSelect) {
                this.generateExistsEnd(this.buf);
            }
        }

        protected void visitExpressionEcmPath(Expression node) {
            Serializable id;
            if (node.operator != Operator.EQ && node.operator != Operator.NOTEQ) {
                throw new QueryMaker.QueryMakerException("ecm:path requires = or <> operator");
            }
            if (!(node.rvalue instanceof StringLiteral)) {
                throw new QueryMaker.QueryMakerException("ecm:path requires literal path as right argument");
            }
            String path = ((StringLiteral)node.rvalue).value;
            if (path.length() > 1 && path.endsWith(PATH_SEP)) {
                path = path.substring(0, path.length() - PATH_SEP.length());
            }
            try {
                id = NXQLQueryMaker.this.pathResolver.getIdForPath(path);
            }
            catch (StorageException e) {
                throw new QueryMaker.QueryMakerException((Throwable)((Object)e));
            }
            if (id == null) {
                this.buf.append("0=1");
            } else {
                Model cfr_ignored_0 = NXQLQueryMaker.this.model;
                this.visitReference(NXQLQueryMaker.this.hierTable.getColumn("id"));
                this.visitOperator(node.operator);
                this.buf.append('?');
                NXQLQueryMaker.this.whereParams.add(id);
            }
        }

        protected void visitExpressionIsProxy(Expression node) {
            if (node.operator != Operator.EQ && node.operator != Operator.NOTEQ) {
                throw new QueryMaker.QueryMakerException("ecm:isProxy requires = or <> operator");
            }
            if (!(node.rvalue instanceof IntegerLiteral)) {
                throw new QueryMaker.QueryMakerException("ecm:isProxy requires literal 0 or 1 as right argument");
            }
            long v = ((IntegerLiteral)node.rvalue).value;
            if (v != 0L && v != 1L) {
                throw new QueryMaker.QueryMakerException("ecm:isProxy requires literal 0 or 1 as right argument");
            }
            boolean bool = node.operator == Operator.EQ ^ v == 0L;
            this.buf.append(this.isProxies == bool ? "1=1" : "0=1");
        }

        protected void visitExpressionIsVersion(Expression node) {
            if (node.operator != Operator.EQ && node.operator != Operator.NOTEQ) {
                throw new QueryMaker.QueryMakerException("ecm:isCheckedInVersion requires = or <> operator");
            }
            if (!(node.rvalue instanceof IntegerLiteral)) {
                throw new QueryMaker.QueryMakerException("ecm:isCheckedInVersion requires literal 0 or 1 as right argument");
            }
            long v = ((IntegerLiteral)node.rvalue).value;
            if (v != 0L && v != 1L) {
                throw new QueryMaker.QueryMakerException("ecm:isCheckedInVersion requires literal 0 or 1 as right argument");
            }
            boolean bool = node.operator == Operator.EQ ^ v == 0L;
            node.lvalue.accept((IVisitor)this);
            if (bool) {
                this.buf.append(" = " + NXQLQueryMaker.this.dialect.toBooleanValueString(true));
            } else {
                this.buf.append(" IS NULL");
            }
        }

        protected void visitExpressionMixinType(Expression node) {
            HashSet<Object> types;
            Set<String> mixins;
            boolean include;
            Expression expr = node;
            Operator op = expr.operator;
            if (op == Operator.EQ || op == Operator.NOTEQ) {
                boolean bl = include = op == Operator.EQ;
                if (!(expr.rvalue instanceof StringLiteral)) {
                    throw new QueryMaker.QueryMakerException("ecm:mixinType = requires literal string as right argument");
                }
                String value = ((StringLiteral)expr.rvalue).value;
                mixins = Collections.singleton(value);
            } else if (op == Operator.IN || op == Operator.NOTIN) {
                boolean bl = include = op == Operator.IN;
                if (!(expr.rvalue instanceof LiteralList)) {
                    throw new QueryMaker.QueryMakerException("ecm:mixinType = requires string list as right argument");
                }
                mixins = this.getStringLiterals((LiteralList)expr.rvalue);
            } else {
                throw new QueryMaker.QueryMakerException("ecm:mixinType unknown operator: " + op);
            }
            if (include) {
                types = new HashSet();
                for (String mixin : mixins) {
                    types.addAll(NXQLQueryMaker.this.model.getMixinDocumentTypes(mixin));
                }
            } else {
                types = new HashSet<String>(NXQLQueryMaker.this.model.getDocumentTypes());
                for (String mixin : mixins) {
                    types.removeAll(NXQLQueryMaker.this.model.getMixinDocumentTypes(mixin));
                }
            }
            HashSet<String> instanceMixins = new HashSet<String>();
            for (String mixin : mixins) {
                if (MIXINS_NOT_PER_INSTANCE.contains(mixin)) continue;
                instanceMixins.add(mixin);
            }
            if (!types.isEmpty()) {
                Model cfr_ignored_0 = NXQLQueryMaker.this.model;
                Column col = NXQLQueryMaker.this.dataHierTable.getColumn("primarytype");
                this.visitReference(col);
                this.buf.append(" IN ");
                this.buf.append('(');
                Iterator it = types.iterator();
                while (it.hasNext()) {
                    this.visitStringLiteral((String)it.next());
                    if (!it.hasNext()) continue;
                    this.buf.append(", ");
                }
                this.buf.append(')');
                if (!instanceMixins.isEmpty()) {
                    this.buf.append(include ? " OR " : " AND ");
                }
            }
            if (!instanceMixins.isEmpty()) {
                this.buf.append('(');
                Model cfr_ignored_1 = NXQLQueryMaker.this.model;
                Column mixinsColumn = NXQLQueryMaker.this.dataHierTable.getColumn("mixintypes");
                String[] returnParam = new String[1];
                Iterator it = instanceMixins.iterator();
                while (it.hasNext()) {
                    String mixin = (String)it.next();
                    String sql = NXQLQueryMaker.this.dialect.getMatchMixinType(mixinsColumn, mixin, include, returnParam);
                    this.buf.append(sql);
                    if (returnParam[0] != null) {
                        NXQLQueryMaker.this.whereParams.add((Serializable)((Object)returnParam[0]));
                    }
                    if (!it.hasNext()) continue;
                    this.buf.append(include ? " OR " : " AND ");
                }
                if (!include) {
                    this.buf.append(" OR ");
                    this.visitReference(mixinsColumn);
                    this.buf.append(" IS NULL");
                }
                this.buf.append(')');
            }
            if (types.isEmpty() && instanceMixins.isEmpty()) {
                this.buf.append(include ? "0=1" : "0=0");
            }
        }

        protected void visitExpressionFulltext(Expression node, String name) {
            String[] nameref = new String[]{name};
            boolean useIndex = NXQLQueryMaker.findFulltextIndexOrField(NXQLQueryMaker.this.model, nameref);
            name = nameref[0];
            if (node.operator != Operator.EQ && node.operator != Operator.LIKE) {
                throw new QueryMaker.QueryMakerException("ecm:fulltext requires = or LIKE operator");
            }
            if (!(node.rvalue instanceof StringLiteral)) {
                throw new QueryMaker.QueryMakerException("ecm:fulltext requires literal string as right argument");
            }
            if (useIndex) {
                Dialect.FulltextMatchInfo info;
                String fulltextQuery = ((StringLiteral)node.rvalue).value;
                fulltextQuery = NXQLQueryMaker.this.dialect.getDialectFulltextQuery(fulltextQuery);
                ++this.ftJoinNumber;
                Model cfr_ignored_0 = NXQLQueryMaker.this.model;
                Column mainColumn = NXQLQueryMaker.this.dataHierTable.getColumn("id");
                this.ftMatchInfo = info = NXQLQueryMaker.this.dialect.getFulltextScoredMatchInfo(fulltextQuery, name, this.ftJoinNumber, mainColumn, NXQLQueryMaker.this.model, NXQLQueryMaker.this.database);
                if (info.joins != null) {
                    NXQLQueryMaker.this.joins.addAll(info.joins);
                }
                this.buf.append(info.whereExpr);
                if (info.whereExprParam != null) {
                    NXQLQueryMaker.this.whereParams.add((Serializable)((Object)info.whereExprParam));
                }
            } else {
                log.warn((Object)("No fulltext index configured for field " + name + ", falling back on LIKE query"));
                String value = ((StringLiteral)node.rvalue).value;
                Set words = FullTextUtils.parseFullText((String)value, (boolean)false);
                value = words.isEmpty() ? "DONTMATCHANYTHINGFOREMPTYQUERY" : "%" + StringUtils.join(new ArrayList(words), (String)"%") + "%";
                Reference ref = new Reference(name);
                if (NXQLQueryMaker.this.dialect.supportsIlike()) {
                    this.visitReference(ref);
                    this.buf.append(" ILIKE ");
                    this.visitStringLiteral(value);
                } else {
                    this.buf.append("LOWER(");
                    this.visitReference(ref);
                    this.buf.append(") LIKE ");
                    this.visitStringLiteral(value);
                }
            }
        }

        protected void visitExpressionIlike(Column lvalue, Operator op, Operand rvalue) {
            if (NXQLQueryMaker.this.dialect.supportsIlike()) {
                this.visitReference(lvalue);
                op.accept((IVisitor)this);
                rvalue.accept((IVisitor)this);
            } else {
                this.buf.append("LOWER(");
                this.visitReference(lvalue);
                this.buf.append(") ");
                if (op == Operator.NOTILIKE) {
                    this.buf.append("NOT ");
                }
                this.buf.append("LIKE");
                this.buf.append(" LOWER(");
                rvalue.accept((IVisitor)this);
                this.buf.append(")");
            }
        }

        public void visitOperator(Operator node) {
            if (node != Operator.NOT) {
                this.buf.append(' ');
            }
            this.buf.append(node.toString());
            this.buf.append(' ');
        }

        public void visitReference(Reference node) {
            String name = node.name;
            Column column = this.findColumn(name, this.allowSubSelect, this.inOrderBy);
            if (this.inSelect) {
                this.whatColumns.add(column);
                this.whatKeys.add(name);
            } else {
                this.visitReference(column, node.cast);
            }
        }

        protected void visitReference(Column column) {
            this.visitReference(column, null);
        }

        protected void visitReference(Column column, String cast) {
            String colFmt;
            if (NXQLQueryMaker.DATE_CAST.equals(cast) && column.getType() != ColumnType.TIMESTAMP) {
                throw new QueryMaker.QueryMakerException("Cannot cast to " + cast + ": " + column);
            }
            String qname = column.getFullQuotedName();
            if (column.getJdbcType() == 2005 && (colFmt = NXQLQueryMaker.this.dialect.getClobCast(this.inOrderBy)) != null) {
                qname = String.format(colFmt, qname, 255);
            }
            if (cast != null) {
                String fmt = NXQLQueryMaker.this.dialect.getDateCast();
                this.buf.append(String.format(fmt, qname));
            } else {
                this.buf.append(qname);
            }
        }

        public void visitLiteralList(LiteralList node) {
            this.buf.append('(');
            Iterator it = node.iterator();
            while (it.hasNext()) {
                ((Literal)it.next()).accept((IVisitor)this);
                if (!it.hasNext()) continue;
                this.buf.append(", ");
            }
            this.buf.append(')');
        }

        public void visitDateLiteral(DateLiteral node) {
            this.buf.append('?');
            if (node.onlyDate) {
                NXQLQueryMaker.this.whereParams.add(node.toSqlDate());
            } else {
                NXQLQueryMaker.this.whereParams.add(node.toCalendar());
            }
        }

        public void visitStringLiteral(StringLiteral node) {
            this.visitStringLiteral(node.value);
        }

        public void visitStringLiteral(String string) {
            this.buf.append('?');
            NXQLQueryMaker.this.whereParams.add((Serializable)((Object)string));
        }

        public void visitDoubleLiteral(DoubleLiteral node) {
            this.buf.append('?');
            NXQLQueryMaker.this.whereParams.add(Double.valueOf(node.value));
        }

        public void visitIntegerLiteral(IntegerLiteral node) {
            this.buf.append('?');
            NXQLQueryMaker.this.whereParams.add(Long.valueOf(node.value));
        }

        public void visitBooleanLiteral(BooleanLiteral node) {
            this.buf.append('?');
            NXQLQueryMaker.this.whereParams.add(Boolean.valueOf(node.value));
        }

        public void visitOrderByList(OrderByList node) {
            this.inOrderBy = true;
            Iterator it = node.iterator();
            while (it.hasNext()) {
                ((OrderByExpr)it.next()).accept((IVisitor)this);
                if (!it.hasNext()) continue;
                this.buf.append(", ");
            }
            this.inOrderBy = false;
        }

        public void visitOrderByExpr(OrderByExpr node) {
            int length = this.buf.length();
            super.visitOrderByExpr(node);
            if (this.aliasOrderByColumns) {
                this.buf.setLength(length);
                this.buf.append(NXQLQueryMaker.this.aliasesByName.get(node.reference.name));
            }
            if (node.isDescending) {
                this.buf.append(NXQLQueryMaker.this.dialect.getDescending());
            }
        }
    }

    protected static class ColumnInfo {
        public final Column column;
        public final boolean isArrayElement;
        public final boolean needsSubSelect;
        public final boolean isBoolean;

        public ColumnInfo(Column column, boolean isArrayElement, PropertyType propertyType) {
            this.column = column;
            this.isArrayElement = isArrayElement;
            this.needsSubSelect = !isArrayElement && propertyType.isArray();
            this.isBoolean = propertyType == PropertyType.BOOLEAN;
        }
    }

    protected class QueryAnalyzer
    extends DefaultQueryVisitor {
        private static final long serialVersionUID = 1L;
        protected boolean inSelect;
        protected boolean inOrderBy;
        protected final List<Operand> toplevelOperands = new LinkedList<Operand>();
        protected MultiExpression wherePredicate;

        public QueryAnalyzer(FacetFilter facetFilter) {
            if (facetFilter != null) {
                this.addFacetFilterClauses(facetFilter);
            }
        }

        public void addFacetFilterClauses(FacetFilter facetFilter) {
            Expression expr;
            for (String mixin : facetFilter.required) {
                expr = new Expression((Operand)new Reference("ecm:mixinType"), Operator.EQ, (Operand)new StringLiteral(mixin));
                this.toplevelOperands.add((Operand)expr);
            }
            if (!facetFilter.excluded.isEmpty()) {
                LiteralList list = new LiteralList();
                for (String mixin : facetFilter.excluded) {
                    list.add((Object)new StringLiteral(mixin));
                }
                expr = new Expression((Operand)new Reference("ecm:mixinType"), Operator.NOTIN, (Operand)list);
                this.toplevelOperands.add((Operand)expr);
            }
        }

        public void visitQuery(SQLQuery node) {
            this.visitSelectClause(node.select);
            this.visitFromClause(node.from);
            this.visitWhereClause(node.where);
            if (node.orderBy != null) {
                this.visitOrderByClause(node.orderBy);
            }
        }

        public void visitSelectClause(SelectClause node) {
            this.inSelect = true;
            super.visitSelectClause(node);
            this.inSelect = false;
        }

        public void visitFromClause(FromClause node) {
            NXQLQueryMaker.this.onlyRelations = true;
            HashSet<String> fromTypes = new HashSet<String>();
            FromList elements = node.elements;
            for (int i = 0; i < elements.size(); ++i) {
                Set<String> subTypes;
                String typeName = (String)elements.get(i);
                if (NXQLQueryMaker.TYPE_DOCUMENT.equalsIgnoreCase(typeName)) {
                    typeName = NXQLQueryMaker.TYPE_DOCUMENT;
                }
                if ((subTypes = NXQLQueryMaker.this.model.getDocumentSubTypes(typeName)) == null) {
                    throw new QueryMaker.QueryMakerException("Unknown type: " + typeName);
                }
                fromTypes.addAll(subTypes);
                boolean isRelation = false;
                do {
                    if (!NXQLQueryMaker.TYPE_RELATION.equals(typeName)) continue;
                    isRelation = true;
                    break;
                } while ((typeName = NXQLQueryMaker.this.model.getDocumentSuperType(typeName)) != null);
                NXQLQueryMaker.this.onlyRelations = NXQLQueryMaker.this.onlyRelations && isRelation;
            }
            Model cfr_ignored_0 = NXQLQueryMaker.this.model;
            fromTypes.remove("Root");
            LiteralList list = new LiteralList();
            for (String type : fromTypes) {
                list.add((Object)new StringLiteral(type));
            }
            this.toplevelOperands.add((Operand)new Expression((Operand)new Reference("ecm:primaryType"), Operator.IN, (Operand)list));
        }

        public void visitWhereClause(WhereClause node) {
            if (node != null) {
                this.analyzeToplevelOperands((Operand)node.predicate);
            }
            this.wherePredicate = new MultiExpression(Operator.AND, this.toplevelOperands);
            super.visitMultiExpression(this.wherePredicate);
        }

        protected void analyzeToplevelOperands(Operand node) {
            if (node instanceof Expression) {
                Expression expr = (Expression)node;
                Operator op = expr.operator;
                if (op == Operator.AND) {
                    this.analyzeToplevelOperands(expr.lvalue);
                    this.analyzeToplevelOperands(expr.rvalue);
                    return;
                }
                if (op == Operator.EQ || op == Operator.NOTEQ) {
                    String name;
                    if (expr.rvalue instanceof Reference) {
                        expr = new Expression(expr.rvalue, op, expr.lvalue);
                    }
                    if (expr.lvalue instanceof Reference && "ecm:isProxy".equals(name = ((Reference)expr.lvalue).name)) {
                        this.analyzeToplevelIsProxy(expr);
                        return;
                    }
                }
            }
            this.toplevelOperands.add(node);
        }

        protected void analyzeToplevelIsProxy(Expression expr) {
            if (!(expr.rvalue instanceof IntegerLiteral)) {
                throw new QueryMaker.QueryMakerException("ecm:isProxy requires literal 0 or 1 as right argument");
            }
            long v = ((IntegerLiteral)expr.rvalue).value;
            if (v != 0L && v != 1L) {
                throw new QueryMaker.QueryMakerException("ecm:isProxy requires literal 0 or 1 as right argument");
            }
            boolean isEq = expr.operator == Operator.EQ;
            Boolean pr = v == 1L == isEq;
            if (NXQLQueryMaker.this.proxyClause != null && NXQLQueryMaker.this.proxyClause != pr) {
                throw new QueryMaker.QueryCannotMatchException();
            }
            NXQLQueryMaker.this.proxyClause = pr;
        }

        public void visitReference(Reference node) {
            if (node.cast != null && !NXQLQueryMaker.DATE_CAST.equals(node.cast)) {
                throw new QueryMaker.QueryMakerException("Invalid cast: " + node);
            }
            String name = node.name;
            if ("ecm:path".equals(name) || "ecm:isProxy".equals(name) || "ecm:mixinType".equals(name) || "ecm:isCheckedInVersion".equals(name)) {
                if (this.inSelect) {
                    throw new QueryMaker.QueryMakerException("Cannot select on column: " + name);
                }
                if (this.inOrderBy) {
                    throw new QueryMaker.QueryMakerException("Cannot order by column: " + name);
                }
            } else if (!("ecm:primaryType".equals(name) || "ecm:uuid".equals(name) || "ecm:name".equals(name) || "ecm:pos".equals(name) || "ecm:parentId".equals(name) || "ecm:currentLifeCycleState".equals(name) || "ecm:versionLabel".equals(name) || "ecm:lock".equals(name) || "ecm:lockOwner".equals(name) || "ecm:lockCreated".equals(name) || "ecm:fulltextJobId".equals(name))) {
                if (name.startsWith("ecm:fulltext")) {
                    if (this.inSelect) {
                        throw new QueryMaker.QueryMakerException("Cannot select on column: " + name);
                    }
                    if (this.inOrderBy) {
                        throw new QueryMaker.QueryMakerException("Cannot order by column: " + name);
                    }
                    if (NXQLQueryMaker.this.model.getRepositoryDescriptor().fulltextDisabled) {
                        throw new QueryMaker.QueryMakerException("Fulltext disabled by configuration");
                    }
                    String[] nameref = new String[]{name};
                    boolean useIndex = NXQLQueryMaker.findFulltextIndexOrField(NXQLQueryMaker.this.model, nameref);
                    if (!useIndex) {
                        name = nameref[0];
                        this.checkProperty(name);
                    }
                } else {
                    if (name.startsWith("ecm:")) {
                        throw new QueryMaker.QueryMakerException("Unknown field: " + name);
                    }
                    this.checkProperty(name);
                }
            }
            if (this.inSelect) {
                NXQLQueryMaker.this.whatColumnNames.add(name);
            } else if (this.inOrderBy) {
                NXQLQueryMaker.this.orderByColumnNames.add(name);
            }
            if (NXQLQueryMaker.this.hasWildcardIndex(name)) {
                NXQLQueryMaker.this.hasWildcardIndex = true;
                if (this.inOrderBy) {
                    NXQLQueryMaker.this.orderByHasWildcardIndex = true;
                }
            }
        }

        protected void checkProperty(String xpath) {
            String simple = NXQLQueryMaker.simpleXPath(xpath);
            ModelProperty prop = NXQLQueryMaker.this.model.getPathPropertyInfo(simple);
            if (prop == null || prop == ModelProperty.NONE) {
                throw new QueryMaker.QueryMakerException("No such property: " + xpath);
            }
        }

        public void visitFunction(Function node) {
            throw new QueryMaker.QueryMakerException("Function not supported: " + node.toString());
        }

        public void visitOrderByClause(OrderByClause node) {
            this.inOrderBy = true;
            super.visitOrderByClause(node);
            this.inOrderBy = false;
        }
    }

    public static enum DocKind {
        DIRECT,
        PROXY;

    }
}

