/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.net;

import java.io.ObjectInputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.transaction.xa.Xid;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.ProtocolException;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.nuxeo.common.utils.XidImpl;
import org.nuxeo.ecm.core.storage.Credentials;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.Mapper;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.RepositoryImpl;
import org.nuxeo.ecm.core.storage.sql.net.ObjectWriterRequestEntity;

public class MapperClient
implements InvocationHandler {
    public static final Object EOF = Eof.VALUE;
    protected String repositoryId;
    protected Mapper.Identification identification;
    protected final String url;
    protected final HttpClient httpClient;
    protected final Header httpPrincipalHeader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Mapper getMapper(RepositoryImpl repository, Credentials credentials) throws StorageException {
        MapperClient handler = new MapperClient(repository, credentials);
        Mapper mapper = (Mapper)Proxy.newProxyInstance(MapperClient.class.getClassLoader(), new Class[]{Mapper.class}, (InvocationHandler)handler);
        RepositoryImpl repositoryImpl = repository;
        synchronized (repositoryImpl) {
            Mapper.Identification id;
            handler.repositoryId = repository.repositoryId;
            handler.identification = id = mapper.getIdentification();
            repository.repositoryId = id.repositoryId;
        }
        return mapper;
    }

    protected MapperClient(RepositoryImpl repository, Credentials credentials) {
        this.httpClient = repository.getHttpClient();
        RepositoryDescriptor desc = repository.getRepositoryDescriptor();
        this.url = MapperClient.getUrl(desc);
        this.httpPrincipalHeader = MapperClient.getHttpPrincipalHeader(credentials);
    }

    protected static Header getHttpPrincipalHeader(Credentials credentials) {
        String username = "[unknown]";
        if (credentials != null) {
            username = credentials.getUserName();
        }
        return new Header("X-Nuxeo-Principal", username);
    }

    protected static String getUrl(RepositoryDescriptor repositoryDescriptor) {
        RepositoryDescriptor.ServerDescriptor sd = repositoryDescriptor.connect.get(0);
        return sd.getUrl() + '/' + "vcs";
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if ("getIdentification".equals(methodName)) {
            if (this.identification != null) {
                return this.identification;
            }
        } else {
            if ("getTableSize".equals(methodName)) {
                return this.getTableSize((String)args[0]);
            }
            if ("createDatabase".equals(methodName)) {
                this.createDatabase();
                return null;
            }
        }
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (!(args[i] instanceof Xid)) continue;
                args[i] = new XidImpl((Xid)args[i]);
            }
        }
        String postUrl = this.url;
        if (this.identification != null) {
            postUrl = postUrl + "?rid=" + this.identification.repositoryId + '&' + "mid" + '=' + this.identification.mapperId;
        } else if (this.repositoryId != null) {
            postUrl = postUrl + "?rid=" + this.repositoryId;
        }
        PostMethod m = new PostMethod(postUrl);
        m.setRequestHeader(this.httpPrincipalHeader);
        try {
            ObjectWriterRequestEntity writer = new ObjectWriterRequestEntity();
            writer.add(methodName, args);
            m.setRequestEntity((RequestEntity)writer);
            int status = this.httpClient.executeMethod((HttpMethod)m);
            if (status != 200) {
                throw new ProtocolException(String.valueOf(status));
            }
            String cs = m.getResponseCharSet();
            if (cs != null && !cs.equals("ISO-8859-1")) {
                throw new RuntimeException("Bad encoding: " + cs);
            }
            Object res = new ObjectInputStream(m.getResponseBodyAsStream()).readObject();
            if (res instanceof Throwable) {
                Throwable t = (Throwable)res;
                throw new StorageException("Remote exception: " + t, t);
            }
            Object object = res;
            return object;
        }
        catch (StorageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new StorageException(e);
        }
        finally {
            m.releaseConnection();
        }
    }

    public int getTableSize(String tableName) {
        return 5;
    }

    public void createDatabase() {
    }

    private static enum Eof {
        VALUE;

    }
}

